/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListenerStub;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheTest;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class CachingPersistentWindowStoreTest {
    private static final int MAX_CACHE_SIZE_BYTES = 150;
    private static final long DEFAULT_TIMESTAMP = 10L;
    private static final Long WINDOW_SIZE = 10L;
    private static final long SEGMENT_INTERVAL = 100L;
    private static final String TOPIC = "topic";
    private static final String CACHE_NAMESPACE = "0_0-store-name";
    private InternalMockProcessorContext<?, ?> context;
    private RocksDBSegmentedBytesStore bytesStore;
    private WindowStore<Bytes, byte[]> underlyingStore;
    private CachingWindowStore cachingStore;
    private CacheFlushListenerStub<Windowed<String>, String> cacheListener;
    private ThreadCache cache;
    private WindowKeySchema keySchema;

    @BeforeEach
    public void setUp() {
        this.keySchema = new WindowKeySchema();
        this.bytesStore = new RocksDBSegmentedBytesStore("test", "metrics-scope", 100L, 100L, (SegmentedBytesStore.KeySchema)this.keySchema);
        this.underlyingStore = new RocksDBWindowStore((SegmentedBytesStore)this.bytesStore, false, WINDOW_SIZE.longValue());
        TimeWindowedDeserializer keyDeserializer = new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE);
        keyDeserializer.setIsChangelogTopic(true);
        this.cacheListener = new CacheFlushListenerStub(keyDeserializer, new StringDeserializer());
        this.cachingStore = new CachingWindowStore(this.underlyingStore, WINDOW_SIZE.longValue(), 100L);
        this.cachingStore.setFlushListener(this.cacheListener, false);
        this.cache = new ThreadCache(new LogContext("testCache "), 150L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.cachingStore.init(this.context, (StateStore)this.cachingStore);
    }

    @AfterEach
    public void closeStore() {
        this.cachingStore.close();
    }

    @Test
    public void shouldDelegateInit() {
        WindowStore inner = (WindowStore)Mockito.mock(WindowStore.class);
        CachingWindowStore outer = new CachingWindowStore(inner, WINDOW_SIZE.longValue(), 100L);
        Mockito.when((Object)inner.name()).thenReturn((Object)"store");
        outer.init(this.context, (StateStore)outer);
        ((WindowStore)Mockito.verify((Object)inner)).init(this.context, (StateStore)outer);
    }

    @Test
    public void shouldNotReturnDuplicatesInRanges() {
        int i;
        StreamsBuilder builder = new StreamsBuilder();
        StoreBuilder storeBuilder = Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store-name", (Duration)Duration.ofHours(1L), (Duration)Duration.ofMinutes(1L), (boolean)false), (Serde)Serdes.String(), (Serde)Serdes.String()).withCachingEnabled();
        builder.addStateStore(storeBuilder);
        builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).process(() -> new Processor<String, String, String, String>(){
            private WindowStore<String, String> store;
            private int numRecordsProcessed;
            private ProcessorContext<String, String> context;

            public void init(ProcessorContext<String, String> processorContext) {
                this.context = processorContext;
                this.store = (WindowStore)processorContext.getStateStore("store-name");
                int count = 0;
                try (KeyValueIterator all = this.store.all();){
                    while (all.hasNext()) {
                        ++count;
                        all.next();
                    }
                }
                MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)0));
            }

            public void process(Record<String, String> record) {
                int count = 0;
                try (KeyValueIterator all = this.store.all();){
                    while (all.hasNext()) {
                        ++count;
                        all.next();
                    }
                }
                MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)this.numRecordsProcessed));
                this.store.put((Object)((String)record.value()), (Object)((String)record.value()), record.timestamp());
                ++this.numRecordsProcessed;
                this.context.forward(record);
            }
        }, new String[]{"store-name"});
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("default.key.serde", Serdes.StringSerde.class);
        streamsConfiguration.put("default.value.serde", Serdes.StringSerde.class);
        streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        streamsConfiguration.put("commit.interval.ms", (Object)10000L);
        Instant initialWallClockTime = Instant.ofEpochMilli(0L);
        TopologyTestDriver driver = new TopologyTestDriver(builder.build(), streamsConfiguration, initialWallClockTime);
        TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), initialWallClockTime, Duration.ZERO);
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.close();
    }

    @Test
    public void shouldPutFetchFromCache() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("a"), 10L), (Matcher)CoreMatchers.equalTo((Object)CachingPersistentWindowStoreTest.bytesValue("a")));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("b"), 10L), (Matcher)CoreMatchers.equalTo((Object)CachingPersistentWindowStoreTest.bytesValue("b")));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("c"), 10L), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("a"), 0L), (Matcher)CoreMatchers.equalTo(null));
        try (WindowStoreIterator a = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));
             WindowStoreIterator b = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)a.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)b.next()), 10L, "b");
            Assertions.assertFalse((boolean)a.hasNext());
            Assertions.assertFalse((boolean)b.hasNext());
            Assertions.assertEquals((long)2L, (long)this.cache.size());
        }
    }

    @Test
    public void shouldMatchPositionAfterPutWithFlushListener() {
        this.cachingStore.setFlushListener(record -> {}, false);
        this.shouldMatchPositionAfterPut();
    }

    @Test
    public void shouldMatchPositionAfterPutWithoutFlushListener() {
        this.cachingStore.setFlushListener(null, false);
        this.shouldMatchPositionAfterPut();
    }

    private void shouldMatchPositionAfterPut() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("key1"), CachingPersistentWindowStoreTest.bytesValue("value1"), 10L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("key2"), CachingPersistentWindowStoreTest.bytesValue("value2"), 10L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        Assertions.assertEquals((Object)Position.emptyPosition(), (Object)this.cachingStore.getPosition());
        Assertions.assertEquals((Object)Position.emptyPosition(), (Object)this.underlyingStore.getPosition());
        this.cachingStore.flush();
        Assertions.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.cachingStore.getPosition());
        Assertions.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.underlyingStore.getPosition());
    }

    private void verifyKeyValue(KeyValue<Long, byte[]> next, long expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)((Long)next.key), (Matcher)CoreMatchers.equalTo((Object)expectedKey));
        MatcherAssert.assertThat((Object)((byte[])next.value), (Matcher)CoreMatchers.equalTo((Object)CachingPersistentWindowStoreTest.bytesValue(expectedValue)));
    }

    private static byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private static Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }

    private String stringFrom(byte[] from) {
        return new StringDeserializer().deserialize("", from);
    }

    @Test
    public void shouldPutFetchRangeFromCache() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
            Assertions.assertEquals((long)2L, (long)this.cache.size());
        }
    }

    @Test
    public void shouldPutFetchRangeFromCacheForNullKeyFrom() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch(null, (Object)CachingPersistentWindowStoreTest.bytesKey("d"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b", "c", "d");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldPutFetchRangeFromCacheForNullKeyTo() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("b"), null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("b", "c", "d", "e");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldPutFetchRangeFromCacheForNullKeyFromKeyTo() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch(null, null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b", "c", "d", "e");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyFrom() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch(null, (Object)CachingPersistentWindowStoreTest.bytesKey("c"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("c", "b", "a");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyTo() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("c"), null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("e", "d", "c");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyFromKeyTo() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch(null, null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("e", "d", "c", "b", "a");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @Test
    public void shouldGetAllFromCache() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("f"), CachingPersistentWindowStoreTest.bytesValue("f"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("g"), CachingPersistentWindowStoreTest.bytesValue("g"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("h"), CachingPersistentWindowStoreTest.bytesValue("h"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.all();){
            String[] array;
            for (String s : array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"}) {
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(s), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), s);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldGetAllBackwardFromCache() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("b"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("c"), CachingPersistentWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("d"), CachingPersistentWindowStoreTest.bytesValue("d"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("e"), CachingPersistentWindowStoreTest.bytesValue("e"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("f"), CachingPersistentWindowStoreTest.bytesValue("f"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("g"), CachingPersistentWindowStoreTest.bytesValue("g"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("h"), CachingPersistentWindowStoreTest.bytesValue("h"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.backwardAll();){
            String[] array;
            for (String s : array = new String[]{"h", "g", "f", "e", "d", "c", "b", "a"}) {
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(s), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), s);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldFetchAllWithinTimestampRange() {
        String str;
        int i;
        String[] array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey(array[i2]), CachingPersistentWindowStoreTest.bytesValue(array[i2]), (long)i2);
        }
        try (KeyValueIterator iterator = this.cachingStore.fetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(7L));){
            for (i = 0; i < array.length; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        try (KeyValueIterator iterator1 = this.cachingStore.fetchAll(Instant.ofEpochMilli(2L), Instant.ofEpochMilli(4L));){
            for (i = 2; i <= 4; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator1.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator1.hasNext());
        }
        try (KeyValueIterator iterator2 = this.cachingStore.fetchAll(Instant.ofEpochMilli(5L), Instant.ofEpochMilli(7L));){
            for (i = 5; i <= 7; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator2.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator2.hasNext());
        }
    }

    @Test
    public void shouldFetchAllBackwardWithinTimestampRange() {
        String str;
        int i;
        String[] array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey(array[i2]), CachingPersistentWindowStoreTest.bytesValue(array[i2]), (long)i2);
        }
        try (KeyValueIterator iterator = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(7L));){
            for (i = array.length - 1; i >= 0; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        try (KeyValueIterator iterator1 = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(2L), Instant.ofEpochMilli(4L));){
            for (i = 4; i >= 2; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator1.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator1.hasNext());
        }
        try (KeyValueIterator iterator2 = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(5L), Instant.ofEpochMilli(7L));){
            for (i = 7; i >= 5; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator2.next()), (Windowed<Bytes>)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator2.hasNext());
        }
    }

    @Test
    public void shouldFlushEvictedItemsIntoUnderlyingStore() {
        int added = this.addItemsToCache();
        try (KeyValueIterator iter = this.bytesStore.fetch(Bytes.wrap((byte[])"0".getBytes(StandardCharsets.UTF_8)), 10L, 10L);){
            KeyValue next = (KeyValue)iter.next();
            Assertions.assertEquals((long)10L, (long)this.keySchema.segmentTimestamp((Bytes)next.key));
            Assertions.assertArrayEquals((byte[])"0".getBytes(), (byte[])((byte[])next.value));
            Assertions.assertFalse((boolean)iter.hasNext());
            Assertions.assertEquals((long)(added - 1), (long)this.cache.size());
        }
    }

    @Test
    public void shouldForwardDirtyItemsWhenFlushCalled() {
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"a", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
    }

    @Test
    public void shouldSetFlushListener() {
        Assertions.assertTrue((boolean)this.cachingStore.setFlushListener(null, true));
        Assertions.assertTrue((boolean)this.cachingStore.setFlushListener(null, false));
    }

    @Test
    public void shouldForwardOldValuesWhenEnabled() {
        this.cachingStore.setFlushListener(this.cacheListener, true);
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull(this.cacheListener.forwarded.get(windowedKey));
        this.cacheListener.forwarded.clear();
    }

    @Test
    public void shouldForwardOldValuesWhenDisabled() {
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull(this.cacheListener.forwarded.get(windowedKey));
        this.cacheListener.forwarded.clear();
    }

    @Test
    public void shouldForwardDirtyItemToListenerWhenEvicted() {
        int numRecords = this.addItemsToCache();
        Assertions.assertEquals((int)numRecords, (int)this.cacheListener.forwarded.size());
    }

    @Test
    public void shouldTakeValueFromCacheIfSameTimestampFlushedToRocks() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.flush();
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @Test
    public void shouldIterateAcrossWindows() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @Test
    public void shouldIterateBackwardAcrossWindows() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("1"), CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @Test
    public void shouldIterateCacheAndStore() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(WindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @Test
    public void shouldIterateBackwardCacheAndStore() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(WindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @Test
    public void shouldIterateCacheAndStoreKeyRange() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(WindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (KeyValueIterator fetchRange = this.cachingStore.fetch((Object)key, (Object)CachingPersistentWindowStoreTest.bytesKey("2"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L + WINDOW_SIZE, 10L + WINDOW_SIZE + WINDOW_SIZE)), "b");
            Assertions.assertFalse((boolean)fetchRange.hasNext());
        }
    }

    @Test
    public void shouldIterateBackwardCacheAndStoreKeyRange() {
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(WindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, CachingPersistentWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (KeyValueIterator fetchRange = this.cachingStore.backwardFetch((Object)key, (Object)CachingPersistentWindowStoreTest.bytesKey("2"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L + WINDOW_SIZE, 10L + WINDOW_SIZE + WINDOW_SIZE)), "b");
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
            Assertions.assertFalse((boolean)fetchRange.hasNext());
        }
    }

    @Test
    public void shouldClearNamespaceCacheOnClose() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 0L);
        Assertions.assertEquals((long)1L, (long)this.cache.size());
        this.cachingStore.close();
        Assertions.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void shouldThrowIfTryingToFetchFromClosedCachingStore() {
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
    }

    @Test
    public void shouldThrowIfTryingToFetchRangeFromClosedCachingStore() {
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
    }

    @Test
    public void shouldThrowIfTryingToWriteToClosedCachingStore() {
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("a"), 0L));
    }

    @Test
    public void shouldFetchAndIterateOverExactKeys() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0005"), 100L);
        List expected = Arrays.asList(KeyValue.pair((Object)0L, (Object)CachingPersistentWindowStoreTest.bytesValue("0001")), KeyValue.pair((Object)1L, (Object)CachingPersistentWindowStoreTest.bytesValue("0003")), KeyValue.pair((Object)100L, (Object)CachingPersistentWindowStoreTest.bytesValue("0005")));
        List actual = StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(expected, actual);
    }

    @Test
    public void shouldBackwardFetchAndIterateOverExactKeys() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0005"), 100L);
        List expected = Arrays.asList(KeyValue.pair((Object)100L, (Object)CachingPersistentWindowStoreTest.bytesValue("0005")), KeyValue.pair((Object)1L, (Object)CachingPersistentWindowStoreTest.bytesValue("0003")), KeyValue.pair((Object)0L, (Object)CachingPersistentWindowStoreTest.bytesValue("0001")));
        List actual = StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(expected, actual);
    }

    @Test
    public void shouldFetchAndIterateOverKeyRange() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0005"), 100L);
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("a", "0001", 0L), CachingPersistentWindowStoreTest.windowedPair("a", "0003", 1L), CachingPersistentWindowStoreTest.windowedPair("a", "0005", 100L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("aa", "0002", 0L), CachingPersistentWindowStoreTest.windowedPair("aa", "0004", 1L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("aa"), (Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("a", "0001", 0L), CachingPersistentWindowStoreTest.windowedPair("a", "0003", 1L), CachingPersistentWindowStoreTest.windowedPair("aa", "0002", 0L), CachingPersistentWindowStoreTest.windowedPair("aa", "0004", 1L), CachingPersistentWindowStoreTest.windowedPair("a", "0005", 100L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
    }

    @Test
    public void shouldFetchAndIterateOverKeyBackwardRange() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0005"), 100L);
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("a", "0005", 100L), CachingPersistentWindowStoreTest.windowedPair("a", "0003", 1L), CachingPersistentWindowStoreTest.windowedPair("a", "0001", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("aa", "0004", 1L), CachingPersistentWindowStoreTest.windowedPair("aa", "0002", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("aa"), (Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(CachingPersistentWindowStoreTest.windowedPair("a", "0005", 100L), CachingPersistentWindowStoreTest.windowedPair("aa", "0004", 1L), CachingPersistentWindowStoreTest.windowedPair("aa", "0002", 0L), CachingPersistentWindowStoreTest.windowedPair("a", "0003", 1L), CachingPersistentWindowStoreTest.windowedPair("a", "0001", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("a"), (Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
    }

    @Test
    public void shouldReturnSameResultsForSingleKeyFetchAndEqualKeyRangeFetch() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0003"), 2L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aaa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 3L);
        try (WindowStoreIterator singleKeyIterator = this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("aa"), 0L, 5L);
             KeyValueIterator keyRangeIterator = this.cachingStore.fetch(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesKey("aa"), 0L, 5L);){
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertFalse((boolean)singleKeyIterator.hasNext());
            Assertions.assertFalse((boolean)keyRangeIterator.hasNext());
        }
    }

    @Test
    public void shouldReturnSameResultsForSingleKeyFetchAndEqualKeyRangeBackwardFetch() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), CachingPersistentWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0002"), 1L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aa"), CachingPersistentWindowStoreTest.bytesValue("0003"), 2L);
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("aaa"), CachingPersistentWindowStoreTest.bytesValue("0004"), 3L);
        try (WindowStoreIterator singleKeyIterator = this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(5L));
             KeyValueIterator keyRangeIterator = this.cachingStore.backwardFetch((Object)CachingPersistentWindowStoreTest.bytesKey("aa"), (Object)CachingPersistentWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(5L));){
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertFalse((boolean)singleKeyIterator.hasNext());
            Assertions.assertFalse((boolean)keyRangeIterator.hasNext());
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.cachingStore.put(null, CachingPersistentWindowStoreTest.bytesValue("anyValue"), 0L));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionOnPutNullValue() {
        this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey("a"), null, 0L);
    }

    @Test
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.cachingStore.fetch(null, Instant.ofEpochMilli(1L), Instant.ofEpochMilli(2L)));
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey() {
        Bytes keyFrom = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(-1)));
        Bytes keyTo = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(1)));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CachingWindowStore.class);
             KeyValueIterator iterator = this.cachingStore.fetch(keyFrom, keyTo, 0L, 10L);){
            Assertions.assertFalse((boolean)iterator.hasNext());
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldNotThrowInvalidBackwardRangeExceptionWithNegativeFromKey() {
        Bytes keyFrom = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(-1)));
        Bytes keyTo = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(1)));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CachingWindowStore.class);
             KeyValueIterator iterator = this.cachingStore.backwardFetch((Object)keyFrom, (Object)keyTo, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));){
            Assertions.assertFalse((boolean)iterator.hasNext());
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @Test
    public void shouldCloseCacheAndWrappedStoreAfterErrorDuringCacheFlush() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache, this.underlyingStore});
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on flush")}).doNothing().when((Object)this.cache)).flush(CACHE_NAMESPACE);
        Assertions.assertThrows(RuntimeException.class, () -> ((CachingWindowStore)this.cachingStore).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).close(CACHE_NAMESPACE);
        ((WindowStore)inOrder.verify(this.underlyingStore)).close();
    }

    @Test
    public void shouldCloseWrappedStoreAfterErrorDuringCacheClose() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache, this.underlyingStore});
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).doNothing().when((Object)this.cache)).close(CACHE_NAMESPACE);
        Assertions.assertThrows(RuntimeException.class, () -> ((CachingWindowStore)this.cachingStore).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).flush(CACHE_NAMESPACE);
        ((WindowStore)inOrder.verify(this.underlyingStore)).close();
    }

    @Test
    public void shouldCloseCacheAfterErrorDuringStateStoreClose() {
        this.setUpCloseTests();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cache});
        ((WindowStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).doNothing().when(this.underlyingStore)).close();
        Assertions.assertThrows(RuntimeException.class, () -> ((CachingWindowStore)this.cachingStore).close());
        ((ThreadCache)inOrder.verify((Object)this.cache)).flush(CACHE_NAMESPACE);
        ((ThreadCache)inOrder.verify((Object)this.cache)).close(CACHE_NAMESPACE);
    }

    private void setUpCloseTests() {
        this.underlyingStore = (WindowStore)Mockito.mock(WindowStore.class);
        Mockito.when((Object)this.underlyingStore.name()).thenReturn((Object)"store-name");
        this.cachingStore = new CachingWindowStore(this.underlyingStore, WINDOW_SIZE.longValue(), 100L);
        this.cache = (ThreadCache)Mockito.mock(ThreadCache.class);
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.cachingStore.init(this.context, (StateStore)this.cachingStore);
    }

    private static KeyValue<Windowed<Bytes>, byte[]> windowedPair(String key, String value, long timestamp) {
        return KeyValue.pair((Object)new Windowed((Object)CachingPersistentWindowStoreTest.bytesKey(key), (Window)new TimeWindow(timestamp, timestamp + WINDOW_SIZE)), (Object)CachingPersistentWindowStoreTest.bytesValue(value));
    }

    private int addItemsToCache() {
        String kv;
        int i = 0;
        for (long cachedSize = 0L; cachedSize < 150L; cachedSize += ThreadCacheTest.memoryCacheEntrySize(kv.getBytes(), kv.getBytes(), TOPIC) + 8L + 4L) {
            kv = String.valueOf(i++);
            this.cachingStore.put(CachingPersistentWindowStoreTest.bytesKey(kv), CachingPersistentWindowStoreTest.bytesValue(kv), 10L);
        }
        return i;
    }
}

