/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingSessionBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ChangeLoggingSessionBytesStoreTest {
    @Mock
    private SessionStore<Bytes, byte[]> inner;
    @Mock
    private ProcessorContextImpl context;
    private ChangeLoggingSessionBytesStore store;
    private final byte[] value1 = new byte[]{0};
    private final Bytes bytesKey = Bytes.wrap((byte[])this.value1);
    private final Windowed<Bytes> key1 = new Windowed((Object)this.bytesKey, (Window)new SessionWindow(0L, 0L));
    private static final Position POSITION = Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)1L)}))}));

    @BeforeEach
    public void setUp() {
        this.store = new ChangeLoggingSessionBytesStore(this.inner);
        this.store.init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @AfterEach
    public void tearDown() {
        ((SessionStore)Mockito.verify(this.inner)).init((StateStoreContext)this.context, (StateStore)this.store);
    }

    @Test
    public void shouldDelegateInit() {
    }

    @Test
    public void shouldLogPuts() {
        Bytes binaryKey = SessionKeySchema.toBinary(this.key1);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        this.store.put(this.key1, this.value1);
        ((SessionStore)Mockito.verify(this.inner)).put(this.key1, (Object)this.value1);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), binaryKey, this.value1, 0L, Position.emptyPosition());
    }

    @Test
    public void shouldLogPutsWithPosition() {
        Bytes binaryKey = SessionKeySchema.toBinary(this.key1);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)POSITION);
        this.store.put(this.key1, this.value1);
        ((SessionStore)Mockito.verify(this.inner)).put(this.key1, (Object)this.value1);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context)).logChange(this.store.name(), binaryKey, this.value1, 0L, POSITION);
    }

    @Test
    public void shouldLogRemoves() {
        Bytes binaryKey = SessionKeySchema.toBinary(this.key1);
        Mockito.when((Object)this.inner.getPosition()).thenReturn((Object)Position.emptyPosition());
        this.store.remove(this.key1);
        this.store.remove(this.key1);
        ((SessionStore)Mockito.verify(this.inner, (VerificationMode)Mockito.times((int)2))).remove(this.key1);
        ((ProcessorContextImpl)Mockito.verify((Object)this.context, (VerificationMode)Mockito.times((int)2))).logChange(this.store.name(), binaryKey, null, 0L, Position.emptyPosition());
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetching() {
        try (KeyValueIterator unused = this.store.fetch(this.bytesKey);){
            ((SessionStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFetching() {
        try (KeyValueIterator unused = this.store.backwardFetch(this.bytesKey);){
            ((SessionStore)Mockito.verify(this.inner)).backwardFetch((Object)this.bytesKey);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFetchingRange() {
        try (KeyValueIterator unused = this.store.fetch(this.bytesKey, this.bytesKey);){
            ((SessionStore)Mockito.verify(this.inner)).fetch((Object)this.bytesKey, (Object)this.bytesKey);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFetchingRange() {
        try (KeyValueIterator unused = this.store.backwardFetch(this.bytesKey, this.bytesKey);){
            ((SessionStore)Mockito.verify(this.inner)).backwardFetch((Object)this.bytesKey, (Object)this.bytesKey);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFindingSessions() {
        try (KeyValueIterator unused = this.store.findSessions(this.bytesKey, 0L, 1L);){
            ((SessionStore)Mockito.verify(this.inner)).findSessions((Object)this.bytesKey, 0L, 1L);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFindingSessions() {
        try (KeyValueIterator unused = this.store.backwardFindSessions(this.bytesKey, 0L, 1L);){
            ((SessionStore)Mockito.verify(this.inner)).backwardFindSessions((Object)this.bytesKey, 0L, 1L);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenFindingSessionRange() {
        try (KeyValueIterator unused = this.store.findSessions(this.bytesKey, this.bytesKey, 0L, 1L);){
            ((SessionStore)Mockito.verify(this.inner)).findSessions((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L);
        }
    }

    @Test
    public void shouldDelegateToUnderlyingStoreWhenBackwardFindingSessionRange() {
        try (KeyValueIterator unused = this.store.backwardFindSessions(this.bytesKey, this.bytesKey, 0L, 1L);){
            ((SessionStore)Mockito.verify(this.inner)).backwardFindSessions((Object)this.bytesKey, (Object)this.bytesKey, 0L, 1L);
        }
    }

    @Test
    public void shouldFlushUnderlyingStore() {
        this.store.flush();
        ((SessionStore)Mockito.verify(this.inner)).flush();
    }

    @Test
    public void shouldCloseUnderlyingStore() {
        this.store.close();
        ((SessionStore)Mockito.verify(this.inner)).close();
    }
}

