/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.internals.CompositeReadOnlySessionStore;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.StreamThreadStateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;
import org.apache.kafka.test.ReadOnlySessionStoreStub;
import org.apache.kafka.test.StateStoreProviderStub;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompositeReadOnlySessionStoreTest {
    private final String storeName = "session-store";
    private final StateStoreProviderStub stubProviderOne = new StateStoreProviderStub(false);
    private final StateStoreProviderStub stubProviderTwo = new StateStoreProviderStub(false);
    private final ReadOnlySessionStoreStub<String, Long> underlyingSessionStore = new ReadOnlySessionStoreStub();
    private final ReadOnlySessionStoreStub<String, Long> otherUnderlyingStore = new ReadOnlySessionStoreStub();
    private CompositeReadOnlySessionStore<String, Long> sessionStore;

    @BeforeEach
    public void before() {
        this.stubProviderOne.addStore("session-store", this.underlyingSessionStore);
        this.stubProviderOne.addStore("other-session-store", this.otherUnderlyingStore);
        QueryableStoreType queryableStoreType = QueryableStoreTypes.sessionStore();
        this.sessionStore = new CompositeReadOnlySessionStore((StateStoreProvider)new WrappingStoreProvider(Arrays.asList(new StreamThreadStateStoreProvider[]{this.stubProviderOne, this.stubProviderTwo}), StoreQueryParameters.fromNameAndType((String)"session-store", (QueryableStoreType)queryableStoreType)), QueryableStoreTypes.sessionStore(), "session-store");
    }

    @Test
    public void shouldFetchResultsFromUnderlyingSessionStore() {
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 1L);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), 2L);
        List results = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch((Object)"a"));
        Assertions.assertEquals(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L)), results);
    }

    @Test
    public void shouldReturnEmptyIteratorIfNoData() {
        try (KeyValueIterator result = this.sessionStore.fetch((Object)"b");){
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void shouldFindValueForKeyWhenMultiStores() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        Windowed keyOne = new Windowed((Object)"key-one", (Window)new SessionWindow(0L, 0L));
        Windowed keyTwo = new Windowed((Object)"key-two", (Window)new SessionWindow(0L, 0L));
        this.underlyingSessionStore.put((Windowed<String>)keyOne, 0L);
        secondUnderlying.put(keyTwo, 10L);
        List keyOneResults = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch((Object)"key-one"));
        List keyTwoResults = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch((Object)"key-two"));
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)keyOne, (Object)0L)), keyOneResults);
        Assertions.assertEquals(Collections.singletonList(KeyValue.pair((Object)keyTwo, (Object)10L)), keyTwoResults);
    }

    @Test
    public void shouldNotGetValueFromOtherStores() {
        Windowed expectedKey = new Windowed((Object)"foo", (Window)new SessionWindow(0L, 0L));
        this.otherUnderlyingStore.put((Windowed<String>)new Windowed((Object)"foo", (Window)new SessionWindow(10L, 10L)), 10L);
        this.underlyingSessionStore.put((Windowed<String>)expectedKey, 1L);
        try (KeyValueIterator result = this.sessionStore.fetch((Object)"foo");){
            Assertions.assertEquals((Object)KeyValue.pair((Object)expectedKey, (Object)1L), (Object)result.next());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionOnRebalance() {
        QueryableStoreType queryableStoreType = QueryableStoreTypes.sessionStore();
        CompositeReadOnlySessionStore store = new CompositeReadOnlySessionStore((StateStoreProvider)new WrappingStoreProvider(Collections.singletonList(new StateStoreProviderStub(true)), StoreQueryParameters.fromNameAndType((String)"whateva", (QueryableStoreType)queryableStoreType)), QueryableStoreTypes.sessionStore(), "whateva");
        Assertions.assertThrows(InvalidStateStoreException.class, () -> store.fetch((Object)"a"));
    }

    @Test
    public void shouldThrowInvalidStateStoreExceptionIfSessionFetchThrows() {
        this.underlyingSessionStore.setOpen(false);
        try {
            this.sessionStore.fetch((Object)"key");
            Assertions.fail((String)"Should have thrown InvalidStateStoreException with session store");
        }
        catch (InvalidStateStoreException invalidStateStoreException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNullPointerExceptionIfFetchingNullKey() {
        Assertions.assertThrows(NullPointerException.class, () -> this.sessionStore.fetch(null));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStores() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch((Object)"a", (Object)"b"));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)0L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), (Object)10L))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyFrom() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch(null, (Object)"b"));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)0L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), (Object)10L))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyTo() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch((Object)"a", null));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)0L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), (Object)10L))));
    }

    @Test
    public void shouldFetchKeyRangeAcrossStoresWithNullKeyFromKeyTo() {
        ReadOnlySessionStoreStub secondUnderlying = new ReadOnlySessionStoreStub();
        this.stubProviderTwo.addStore("session-store", secondUnderlying);
        this.underlyingSessionStore.put((Windowed<String>)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), 0L);
        secondUnderlying.put(new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), 10L);
        List results = StreamsTestUtils.toListAndCloseIterator(this.sessionStore.fetch(null, null));
        MatcherAssert.assertThat(results, (Matcher)IsEqual.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)0L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(0L, 0L)), (Object)10L))));
    }

    @Test
    public void shouldThrowNPEIfKeyIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> this.underlyingSessionStore.fetch(null));
    }
}

