/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.AbstractSessionBytesStoreTest;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InMemorySessionStoreTest
extends AbstractSessionBytesStoreTest {
    @Override
    AbstractSessionBytesStoreTest.StoreType storeType() {
        return AbstractSessionBytesStoreTest.StoreType.InMemoryStore;
    }

    @Test
    public void shouldNotExpireFromOpenIterator() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, 10000L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(100L, 20000L)), (Object)4L);
        Assertions.assertEquals(StreamsTestUtils.valuesToSet(iterator), new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L)));
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        try (KeyValueIterator it = this.sessionStore.findSessions((Object)"a", (Object)"b", 0L, 20L);){
            Assertions.assertFalse((boolean)it.hasNext());
        }
    }
}

