/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueIteratorFacade;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class KeyValueIteratorFacadeTest {
    @Mock
    private KeyValueIterator<String, ValueAndTimestamp<String>> mockedKeyValueIterator;
    private KeyValueIteratorFacade<String, String> keyValueIteratorFacade;

    @BeforeEach
    public void setup() {
        this.keyValueIteratorFacade = new KeyValueIteratorFacade(this.mockedKeyValueIterator);
    }

    @Test
    public void shouldForwardHasNext() {
        Mockito.when((Object)this.mockedKeyValueIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.keyValueIteratorFacade.hasNext());
        Assertions.assertFalse((boolean)this.keyValueIteratorFacade.hasNext());
    }

    @Test
    public void shouldForwardPeekNextKey() {
        Mockito.when((Object)((String)this.mockedKeyValueIterator.peekNextKey())).thenReturn((Object)"key");
        MatcherAssert.assertThat((Object)((String)this.keyValueIteratorFacade.peekNextKey()), (Matcher)Matchers.is((Object)"key"));
    }

    @Test
    public void shouldReturnPlainKeyValuePairOnGet() {
        Mockito.when((Object)((KeyValue)this.mockedKeyValueIterator.next())).thenReturn((Object)new KeyValue((Object)"key", (Object)ValueAndTimestamp.make((Object)"value", (long)42L)));
        MatcherAssert.assertThat((Object)this.keyValueIteratorFacade.next(), (Matcher)Matchers.is((Object)KeyValue.pair((Object)"key", (Object)"value")));
    }

    @Test
    public void shouldCloseInnerIterator() {
        ((KeyValueIterator)Mockito.doNothing().when(this.mockedKeyValueIterator)).close();
        this.keyValueIteratorFacade.close();
    }
}

