/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.KeyValueSegment;
import org.apache.kafka.streams.state.internals.KeyValueSegments;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KeyValueSegmentsTest {
    private static final int NUM_SEGMENTS = 5;
    private static final long SEGMENT_INTERVAL = 100L;
    private static final long RETENTION_PERIOD = 400L;
    private static final String METRICS_SCOPE = "test-state-id";
    private InternalMockProcessorContext context;
    private KeyValueSegments segments;
    private File stateDirectory;
    private final String storeName = "test";

    @BeforeEach
    public void createContext() {
        this.stateDirectory = TestUtils.tempDirectory();
        this.context = new InternalMockProcessorContext(this.stateDirectory, Serdes.String(), Serdes.Long(), new MockRecordCollector(), new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.segments = new KeyValueSegments("test", METRICS_SCOPE, 400L, 100L);
        this.segments.openExisting((StateStoreContext)this.context, -1L);
    }

    @AfterEach
    public void close() {
        this.segments.close();
    }

    @Test
    public void shouldGetSegmentIdsFromTimestamp() {
        Assertions.assertEquals((long)0L, (long)this.segments.segmentId(0L));
        Assertions.assertEquals((long)1L, (long)this.segments.segmentId(100L));
        Assertions.assertEquals((long)2L, (long)this.segments.segmentId(200L));
        Assertions.assertEquals((long)3L, (long)this.segments.segmentId(300L));
    }

    @Test
    public void shouldBaseSegmentIntervalOnRetentionAndNumSegments() {
        KeyValueSegments segments = new KeyValueSegments("test", METRICS_SCOPE, 800L, 200L);
        Assertions.assertEquals((long)0L, (long)segments.segmentId(0L));
        Assertions.assertEquals((long)0L, (long)segments.segmentId(100L));
        Assertions.assertEquals((long)1L, (long)segments.segmentId(200L));
    }

    @Test
    public void shouldGetSegmentNameFromId() {
        Assertions.assertEquals((Object)"test.0", (Object)this.segments.segmentName(0L));
        Assertions.assertEquals((Object)"test.100", (Object)this.segments.segmentName(1L));
        Assertions.assertEquals((Object)"test.200", (Object)this.segments.segmentName(2L));
    }

    @Test
    public void shouldCreateSegments() {
        KeyValueSegment segment1 = this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        KeyValueSegment segment2 = this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, -1L);
        KeyValueSegment segment3 = this.segments.getOrCreateSegmentIfLive(2L, (StateStoreContext)this.context, -1L);
        Assertions.assertTrue((boolean)new File(this.context.stateDir(), "test/test.0").isDirectory());
        Assertions.assertTrue((boolean)new File(this.context.stateDir(), "test/test.100").isDirectory());
        Assertions.assertTrue((boolean)new File(this.context.stateDir(), "test/test.200").isDirectory());
        Assertions.assertTrue((boolean)segment1.isOpen());
        Assertions.assertTrue((boolean)segment2.isOpen());
        Assertions.assertTrue((boolean)segment3.isOpen());
    }

    @Test
    public void shouldNotCreateSegmentThatIsAlreadyExpired() {
        long streamTime = this.updateStreamTimeAndCreateSegment(7);
        Assertions.assertNull((Object)this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, streamTime));
        Assertions.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
    }

    @Test
    public void shouldCleanupSegmentsThatHaveExpired() {
        KeyValueSegment segment1 = this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        KeyValueSegment segment2 = this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, -1L);
        KeyValueSegment segment3 = this.segments.getOrCreateSegmentIfLive(7L, (StateStoreContext)this.context, 700L);
        Assertions.assertFalse((boolean)segment1.isOpen());
        Assertions.assertFalse((boolean)segment2.isOpen());
        Assertions.assertTrue((boolean)segment3.isOpen());
        Assertions.assertFalse((boolean)new File(this.context.stateDir(), "test/test.0").exists());
        Assertions.assertFalse((boolean)new File(this.context.stateDir(), "test/test.100").exists());
        Assertions.assertTrue((boolean)new File(this.context.stateDir(), "test/test.700").exists());
    }

    @Test
    public void shouldGetSegmentForTimestamp() {
        KeyValueSegment segment = this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, -1L);
        Assertions.assertEquals((Object)segment, (Object)this.segments.segmentForTimestamp(0L));
    }

    @Test
    public void shouldGetCorrectSegmentString() {
        KeyValueSegment segment = this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        Assertions.assertEquals((Object)"KeyValueSegment(id=0, name=test.0)", (Object)segment.toString());
    }

    @Test
    public void shouldCloseAllOpenSegments() {
        KeyValueSegment first = this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        KeyValueSegment second = this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, -1L);
        KeyValueSegment third = this.segments.getOrCreateSegmentIfLive(2L, (StateStoreContext)this.context, -1L);
        this.segments.close();
        Assertions.assertFalse((boolean)first.isOpen());
        Assertions.assertFalse((boolean)second.isOpen());
        Assertions.assertFalse((boolean)third.isOpen());
    }

    @Test
    public void shouldOpenExistingSegments() {
        this.segments = new KeyValueSegments("test", METRICS_SCOPE, 4L, 1L);
        this.segments.openExisting((StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(2L, (StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(3L, (StateStoreContext)this.context, -1L);
        this.segments.getOrCreateSegmentIfLive(4L, (StateStoreContext)this.context, -1L);
        this.segments.close();
        this.segments = new KeyValueSegments("test", METRICS_SCOPE, 4L, 1L);
        this.segments.openExisting((StateStoreContext)this.context, -1L);
        Assertions.assertTrue((boolean)((KeyValueSegment)this.segments.segmentForTimestamp(0L)).isOpen());
        Assertions.assertTrue((boolean)((KeyValueSegment)this.segments.segmentForTimestamp(1L)).isOpen());
        Assertions.assertTrue((boolean)((KeyValueSegment)this.segments.segmentForTimestamp(2L)).isOpen());
        Assertions.assertTrue((boolean)((KeyValueSegment)this.segments.segmentForTimestamp(3L)).isOpen());
        Assertions.assertTrue((boolean)((KeyValueSegment)this.segments.segmentForTimestamp(4L)).isOpen());
    }

    @Test
    public void shouldGetSegmentsWithinTimeRange() {
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(3);
        long streamTime = this.updateStreamTimeAndCreateSegment(4);
        this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(2L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(3L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(4L, (StateStoreContext)this.context, streamTime);
        List segments = this.segments.segments(0L, 200L, true);
        Assertions.assertEquals((int)3, (int)segments.size());
        Assertions.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)0)).id);
        Assertions.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assertions.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)2)).id);
    }

    @Test
    public void shouldGetSegmentsWithinBackwardTimeRange() {
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(3);
        long streamTime = this.updateStreamTimeAndCreateSegment(4);
        this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(1L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(2L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(3L, (StateStoreContext)this.context, streamTime);
        this.segments.getOrCreateSegmentIfLive(4L, (StateStoreContext)this.context, streamTime);
        List segments = this.segments.segments(0L, 200L, false);
        Assertions.assertEquals((int)3, (int)segments.size());
        Assertions.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)2)).id);
        Assertions.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assertions.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)0)).id);
    }

    @Test
    public void shouldGetSegmentsWithinTimeRangeOutOfOrder() {
        this.updateStreamTimeAndCreateSegment(4);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(3);
        List segments = this.segments.segments(0L, 200L, true);
        Assertions.assertEquals((int)3, (int)segments.size());
        Assertions.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)0)).id);
        Assertions.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assertions.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)2)).id);
    }

    @Test
    public void shouldGetSegmentsWithinTimeBackwardRangeOutOfOrder() {
        this.updateStreamTimeAndCreateSegment(4);
        this.updateStreamTimeAndCreateSegment(2);
        this.updateStreamTimeAndCreateSegment(0);
        this.updateStreamTimeAndCreateSegment(1);
        this.updateStreamTimeAndCreateSegment(3);
        List segments = this.segments.segments(0L, 200L, false);
        Assertions.assertEquals((int)3, (int)segments.size());
        Assertions.assertEquals((long)2L, (long)((KeyValueSegment)segments.get((int)0)).id);
        Assertions.assertEquals((long)1L, (long)((KeyValueSegment)segments.get((int)1)).id);
        Assertions.assertEquals((long)0L, (long)((KeyValueSegment)segments.get((int)2)).id);
    }

    @Test
    public void shouldRollSegments() {
        this.updateStreamTimeAndCreateSegment(0);
        this.verifyCorrectSegments(0L, 1);
        this.updateStreamTimeAndCreateSegment(1);
        this.verifyCorrectSegments(0L, 2);
        this.updateStreamTimeAndCreateSegment(2);
        this.verifyCorrectSegments(0L, 3);
        this.updateStreamTimeAndCreateSegment(3);
        this.verifyCorrectSegments(0L, 4);
        this.updateStreamTimeAndCreateSegment(4);
        this.verifyCorrectSegments(0L, 5);
        this.updateStreamTimeAndCreateSegment(5);
        this.verifyCorrectSegments(1L, 5);
        this.updateStreamTimeAndCreateSegment(6);
        this.verifyCorrectSegments(2L, 5);
    }

    @Test
    public void futureEventsShouldNotCauseSegmentRoll() {
        this.updateStreamTimeAndCreateSegment(0);
        this.verifyCorrectSegments(0L, 1);
        this.updateStreamTimeAndCreateSegment(1);
        this.verifyCorrectSegments(0L, 2);
        this.updateStreamTimeAndCreateSegment(2);
        this.verifyCorrectSegments(0L, 3);
        this.updateStreamTimeAndCreateSegment(3);
        this.verifyCorrectSegments(0L, 4);
        long streamTime = this.updateStreamTimeAndCreateSegment(4);
        this.verifyCorrectSegments(0L, 5);
        this.segments.getOrCreateSegmentIfLive(5L, (StateStoreContext)this.context, streamTime);
        this.verifyCorrectSegments(0L, 6);
        this.segments.getOrCreateSegmentIfLive(6L, (StateStoreContext)this.context, streamTime);
        this.verifyCorrectSegments(0L, 7);
    }

    private long updateStreamTimeAndCreateSegment(int segment) {
        long streamTime = 100L * (long)segment;
        this.segments.getOrCreateSegmentIfLive((long)segment, (StateStoreContext)this.context, streamTime);
        return streamTime;
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldDateFormatToNewFormat() throws Exception {
        int segmentId;
        long segmentInterval = 60000L;
        this.segments = new KeyValueSegments("test", METRICS_SCOPE, 300000L, 60000L);
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + "test";
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + "test-" + formatter.format(new Date((long)segmentId * 60000L)));
            Files.createFile(oldSegment.toPath(), new FileAttribute[0]);
        }
        this.segments.openExisting((StateStoreContext)this.context, -1L);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            String segmentName = "test." + (long)segmentId * 60000L;
            File newSegment = new File(storeDirectoryPath + File.separator + segmentName);
            Assertions.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldUpdateSegmentFileNameFromOldColonFormatToNewFormat() throws Exception {
        int segmentId;
        String storeDirectoryPath = this.stateDirectory.getAbsolutePath() + File.separator + "test";
        File storeDirectory = new File(storeDirectoryPath);
        storeDirectory.mkdirs();
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File oldSegment = new File(storeDirectoryPath + File.separator + "test:" + (long)segmentId * 100L);
            Files.createFile(oldSegment.toPath(), new FileAttribute[0]);
        }
        this.segments.openExisting((StateStoreContext)this.context, -1L);
        for (segmentId = 0; segmentId < 5; ++segmentId) {
            File newSegment = new File(storeDirectoryPath + File.separator + "test." + (long)segmentId * 100L);
            Assertions.assertTrue((boolean)newSegment.exists());
        }
    }

    @Test
    public void shouldClearSegmentsOnClose() {
        this.segments.getOrCreateSegmentIfLive(0L, (StateStoreContext)this.context, -1L);
        this.segments.close();
        MatcherAssert.assertThat((Object)((KeyValueSegment)this.segments.segmentForTimestamp(0L)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void verifyCorrectSegments(long first, int numSegments) {
        List result = this.segments.segments(0L, Long.MAX_VALUE, true);
        Assertions.assertEquals((int)numSegments, (int)result.size());
        for (int i = 0; i < numSegments; ++i) {
            Assertions.assertEquals((long)((long)i + first), (long)((KeyValueSegment)result.get((int)i)).id);
        }
    }
}

