/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.internals.ListValueStoreBuilder;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class ListValueStoreTest {
    private KeyValueStore<Integer, String> listStore;
    final File baseDir = TestUtils.tempDirectory((String)"test");

    public void setup(StoreType storeType) {
        this.listStore = this.buildStore(Serdes.Integer(), Serdes.String(), storeType);
        MockRecordCollector recordCollector = new MockRecordCollector();
        InternalMockProcessorContext context = new InternalMockProcessorContext(this.baseDir, Serdes.String(), Serdes.Integer(), recordCollector, new ThreadCache(new LogContext("testCache"), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        context.setTime(1L);
        this.listStore.init(context, this.listStore);
    }

    @AfterEach
    public void after() {
        this.listStore.close();
    }

    <K, V> KeyValueStore<K, V> buildStore(Serde<K> keySerde, Serde<V> valueSerde, StoreType storeType) {
        return new ListValueStoreBuilder(storeType == StoreType.RocksDB ? Stores.persistentKeyValueStore((String)"rocksDB list store") : Stores.inMemoryKeyValueStore((String)"in-memory list store"), keySerde, valueSerde, Time.SYSTEM).build();
    }

    @ParameterizedTest
    @EnumSource(value=StoreType.class)
    public void shouldGetAll(StoreType storeType) {
        this.setup(storeType);
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)0, (Object)"zero again");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)2, (Object)"two");
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue zeroAgain = KeyValue.pair((Object)0, (Object)"zero again");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValue two = KeyValue.pair((Object)2, (Object)"two");
        Assertions.assertEquals(Arrays.asList(zero, zeroAgain, one, two), StreamsTestUtils.toListAndCloseIterator(this.listStore.all()));
    }

    @ParameterizedTest
    @EnumSource(value=StoreType.class)
    public void shouldGetAllNonDeletedRecords(StoreType storeType) {
        this.setup(storeType);
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)1, (Object)"one again");
        this.listStore.put((Object)2, (Object)"two");
        this.listStore.put((Object)3, (Object)"three");
        this.listStore.put((Object)4, (Object)"four");
        this.listStore.put((Object)1, null);
        this.listStore.put((Object)3, null);
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue two = KeyValue.pair((Object)2, (Object)"two");
        KeyValue four = KeyValue.pair((Object)4, (Object)"four");
        Assertions.assertEquals(Arrays.asList(zero, two, four), StreamsTestUtils.toListAndCloseIterator(this.listStore.all()));
    }

    @ParameterizedTest
    @EnumSource(value=StoreType.class)
    public void shouldGetAllReturnTimestampOrderedRecords(StoreType storeType) {
        this.setup(storeType);
        this.listStore.put((Object)4, (Object)"four");
        this.listStore.put((Object)0, (Object)"zero");
        this.listStore.put((Object)2, (Object)"two1");
        this.listStore.put((Object)3, (Object)"three");
        this.listStore.put((Object)1, (Object)"one");
        this.listStore.put((Object)2, (Object)"two2");
        KeyValue zero = KeyValue.pair((Object)0, (Object)"zero");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValue two1 = KeyValue.pair((Object)2, (Object)"two1");
        KeyValue two2 = KeyValue.pair((Object)2, (Object)"two2");
        KeyValue three = KeyValue.pair((Object)3, (Object)"three");
        KeyValue four = KeyValue.pair((Object)4, (Object)"four");
        Assertions.assertEquals(Arrays.asList(zero, one, two1, two2, three, four), StreamsTestUtils.toListAndCloseIterator(this.listStore.all()));
    }

    @ParameterizedTest
    @EnumSource(value=StoreType.class)
    public void shouldAllowDeleteWhileIterateRecords(StoreType storeType) {
        this.setup(storeType);
        this.listStore.put((Object)0, (Object)"zero1");
        this.listStore.put((Object)0, (Object)"zero2");
        this.listStore.put((Object)1, (Object)"one");
        KeyValue zero1 = KeyValue.pair((Object)0, (Object)"zero1");
        KeyValue zero2 = KeyValue.pair((Object)0, (Object)"zero2");
        KeyValue one = KeyValue.pair((Object)1, (Object)"one");
        KeyValueIterator it = this.listStore.all();
        Assertions.assertEquals((Object)zero1, (Object)it.next());
        this.listStore.put((Object)0, null);
        Assertions.assertEquals((Object)zero2, (Object)it.next());
        it.close();
        Assertions.assertEquals(Collections.singletonList(one), StreamsTestUtils.toListAndCloseIterator(this.listStore.all()));
    }

    @ParameterizedTest
    @EnumSource(value=StoreType.class)
    public void shouldNotReturnMoreDataWhenIteratorClosed(StoreType storeType) {
        this.setup(storeType);
        this.listStore.put((Object)0, (Object)"zero1");
        this.listStore.put((Object)0, (Object)"zero2");
        this.listStore.put((Object)1, (Object)"one");
        KeyValueIterator it = this.listStore.all();
        it.close();
        if (storeType == StoreType.InMemory) {
            Assertions.assertThrows(IllegalStateException.class, () -> it.next());
        } else {
            Assertions.assertThrows(InvalidStateStoreException.class, () -> it.next());
        }
    }

    public static enum StoreType {
        InMemory,
        RocksDB;

    }
}

