/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.LogicalKeyValueSegment;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LogicalKeyValueSegmentTest {
    private static final String STORE_NAME = "physical-rocks";
    private static final String METRICS_SCOPE = "metrics-scope";
    private static final String DB_FILE_DIR = "rocksdb";
    private static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    private static final Deserializer<String> STRING_DESERIALIZER = new StringDeserializer();
    private RocksDBStore physicalStore;
    private LogicalKeyValueSegment segment0;
    private LogicalKeyValueSegment segment1;
    private LogicalKeyValueSegment segment2;
    private LogicalKeyValueSegment negativeIdSegment;

    @BeforeEach
    public void setUp() {
        this.physicalStore = new RocksDBStore(STORE_NAME, DB_FILE_DIR, new RocksDBMetricsRecorder(METRICS_SCOPE, STORE_NAME), false);
        this.physicalStore.init(new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.String(), new StreamsConfig((Map)StreamsTestUtils.getStreamsConfig())), (StateStore)this.physicalStore);
        this.segment0 = new LogicalKeyValueSegment(0L, "segment-0", this.physicalStore);
        this.segment1 = new LogicalKeyValueSegment(1L, "segment-1", this.physicalStore);
        this.segment2 = new LogicalKeyValueSegment(2L, "segment-2", this.physicalStore);
        this.negativeIdSegment = new LogicalKeyValueSegment(-1L, "reserved-segment", this.physicalStore);
    }

    @AfterEach
    public void tearDown() {
        this.segment0.close();
        this.segment1.close();
        this.segment2.close();
        this.physicalStore.close();
    }

    @Test
    public void shouldPut() {
        KeyValue sharedKeyV1 = new KeyValue((Object)"shared", (Object)"v1");
        KeyValue sharedKeyV2 = new KeyValue((Object)"shared", (Object)"v2");
        KeyValue sharedKeyV3 = new KeyValue((Object)"shared", (Object)"v3");
        KeyValue segment0KeyOnly = new KeyValue((Object)"segment0_only", (Object)"foo");
        KeyValue segment1KeyOnly = new KeyValue((Object)"segment1_only", (Object)"bar");
        KeyValue negativeSegmentKeyOnly = new KeyValue((Object)"negative_segment_only", (Object)"baz");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV1.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)segment0KeyOnly.key)), LogicalKeyValueSegmentTest.serializeBytes((String)segment0KeyOnly.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV2.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)segment1KeyOnly.key)), LogicalKeyValueSegmentTest.serializeBytes((String)segment1KeyOnly.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV3.key)), LogicalKeyValueSegmentTest.serializeBytes((String)sharedKeyV3.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)negativeSegmentKeyOnly.key)), LogicalKeyValueSegmentTest.serializeBytes((String)negativeSegmentKeyOnly.value));
        Assertions.assertEquals((Object)"v1", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "shared"));
        Assertions.assertEquals((Object)"v2", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "shared"));
        Assertions.assertEquals((Object)"v3", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "shared"));
        Assertions.assertEquals((Object)"foo", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "segment1_only"));
        Assertions.assertEquals((Object)"bar", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "segment1_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "segment1_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "negative_segment_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "negative_segment_only"));
        Assertions.assertEquals((Object)"baz", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "negative_segment_only"));
    }

    @Test
    public void shouldPutAll() {
        ArrayList<KeyValue> segment0Records = new ArrayList<KeyValue>();
        segment0Records.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("shared")), (Object)LogicalKeyValueSegmentTest.serializeBytes("v1")));
        segment0Records.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("segment0_only")), (Object)LogicalKeyValueSegmentTest.serializeBytes("foo")));
        ArrayList<KeyValue> segment1Records = new ArrayList<KeyValue>();
        segment1Records.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("shared")), (Object)LogicalKeyValueSegmentTest.serializeBytes("v2")));
        segment1Records.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("segment1_only")), (Object)LogicalKeyValueSegmentTest.serializeBytes("bar")));
        ArrayList<KeyValue> negativeSegmentRecords = new ArrayList<KeyValue>();
        negativeSegmentRecords.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("shared")), (Object)LogicalKeyValueSegmentTest.serializeBytes("v3")));
        negativeSegmentRecords.add(new KeyValue((Object)new Bytes(LogicalKeyValueSegmentTest.serializeBytes("negative_segment_only")), (Object)LogicalKeyValueSegmentTest.serializeBytes("baz")));
        this.segment0.putAll(segment0Records);
        this.segment1.putAll(segment1Records);
        this.negativeIdSegment.putAll(negativeSegmentRecords);
        Assertions.assertEquals((Object)"v1", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "shared"));
        Assertions.assertEquals((Object)"v2", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "shared"));
        Assertions.assertEquals((Object)"v3", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "shared"));
        Assertions.assertEquals((Object)"foo", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "segment0_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "segment1_only"));
        Assertions.assertEquals((Object)"bar", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "segment1_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "segment1_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "negative_segment_only"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "negative_segment_only"));
        Assertions.assertEquals((Object)"baz", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "negative_segment_only"));
    }

    @Test
    public void shouldPutIfAbsent() {
        Bytes keyBytes = new Bytes(LogicalKeyValueSegmentTest.serializeBytes("one"));
        byte[] valueBytes1 = LogicalKeyValueSegmentTest.serializeBytes("A");
        byte[] valueBytes2 = LogicalKeyValueSegmentTest.serializeBytes("B");
        byte[] valueBytesUpdate = LogicalKeyValueSegmentTest.serializeBytes("C");
        this.segment0.putIfAbsent(keyBytes, valueBytes1);
        this.negativeIdSegment.putIfAbsent(keyBytes, valueBytes2);
        Assertions.assertEquals((Object)"A", (Object)STRING_DESERIALIZER.deserialize(null, this.segment0.get(keyBytes)));
        Assertions.assertEquals((Object)"B", (Object)STRING_DESERIALIZER.deserialize(null, this.negativeIdSegment.get(keyBytes)));
        this.segment0.putIfAbsent(keyBytes, valueBytesUpdate);
        this.negativeIdSegment.putIfAbsent(keyBytes, valueBytesUpdate);
        Assertions.assertEquals((Object)"A", (Object)STRING_DESERIALIZER.deserialize(null, this.segment0.get(keyBytes)));
        Assertions.assertEquals((Object)"B", (Object)STRING_DESERIALIZER.deserialize(null, this.negativeIdSegment.get(keyBytes)));
    }

    @Test
    public void shouldDelete() {
        KeyValue kv0 = new KeyValue((Object)"1", (Object)"a");
        KeyValue kv1 = new KeyValue((Object)"2", (Object)"b");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment0.delete(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, (String)kv0.key));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "2"));
        Assertions.assertEquals((Object)"a", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "1"));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "2"));
    }

    @Test
    public void shouldDeleteFromSegmentWithNegativeId() {
        KeyValue kv0 = new KeyValue((Object)"1", (Object)"a");
        KeyValue kv1 = new KeyValue((Object)"2", (Object)"b");
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment2.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment2.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.delete(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, (String)kv0.key));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "2"));
        Assertions.assertEquals((Object)"a", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment2, "1"));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment2, "2"));
    }

    @Test
    public void shouldReturnValuesOnRange() {
        LinkedList<KeyValue> expectedContents;
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        this.segment2.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        try (KeyValueIterator iterator = this.segment1.range(new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")), new Bytes(LogicalKeyValueSegmentTest.serializeBytes("2")));){
            expectedContents = new LinkedList<KeyValue>();
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        iterator = this.segment1.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv0);
            expectedContents.add(kv1);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        iterator = this.segment1.range(new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")), null);
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        iterator = this.segment1.range(null, null);
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv0);
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    @Test
    public void shouldReturnValuesOnRangeFromSegmentWithNegativeId() {
        LinkedList<KeyValue> expectedContents;
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        try (KeyValueIterator iterator = this.negativeIdSegment.range(new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")), new Bytes(LogicalKeyValueSegmentTest.serializeBytes("2")));){
            expectedContents = new LinkedList<KeyValue>();
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        iterator = this.negativeIdSegment.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv0);
            expectedContents.add(kv1);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        iterator = this.negativeIdSegment.range(new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")), null);
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        iterator = this.negativeIdSegment.range(null, null);
        try {
            expectedContents = new LinkedList();
            expectedContents.add(kv0);
            expectedContents.add(kv1);
            expectedContents.add(kv2);
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    @Test
    public void shouldReturnAll() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        this.segment2.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(kv0);
        expectedContents.add(kv1);
        expectedContents.add(kv2);
        try (KeyValueIterator iterator = this.segment1.all();){
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
    }

    @Test
    public void shouldReturnAllFromSegmentWithNegativeId() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        LinkedList<KeyValue> expectedContents = new LinkedList<KeyValue>();
        expectedContents.add(kv0);
        expectedContents.add(kv1);
        expectedContents.add(kv2);
        try (KeyValueIterator iterator = this.negativeIdSegment.all();){
            Assertions.assertEquals(expectedContents, LogicalKeyValueSegmentTest.getDeserializedList((KeyValueIterator<Bytes, byte[]>)iterator));
        }
    }

    @Test
    public void shouldDeleteRange() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        this.segment0.deleteRange(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "0"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "1"));
        Assertions.assertEquals((Object)"two", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "2"));
        Assertions.assertEquals((Object)"other", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "1"));
    }

    @Test
    public void shouldDeleteRangeFromSegmentWithNegativeId() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        KeyValue kv2 = new KeyValue((Object)"2", (Object)"two");
        KeyValue kvOther = new KeyValue((Object)"1", (Object)"other");
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv2.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv2.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kvOther.value));
        this.negativeIdSegment.deleteRange(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "0"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "1"));
        Assertions.assertEquals((Object)"two", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "2"));
        Assertions.assertEquals((Object)"other", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "1"));
    }

    @Test
    public void shouldDestroy() {
        KeyValue kv0 = new KeyValue((Object)"1", (Object)"a");
        KeyValue kv1 = new KeyValue((Object)"2", (Object)"b");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment0.destroy();
        Assertions.assertEquals((Object)"a", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "1"));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment1, "2"));
        Assertions.assertEquals((Object)"a", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "1"));
        Assertions.assertEquals((Object)"b", (Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.negativeIdSegment, "2"));
        this.segment0 = new LogicalKeyValueSegment(0L, "segment-0", this.physicalStore);
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "1"));
        Assertions.assertNull((Object)LogicalKeyValueSegmentTest.getAndDeserialize(this.segment0, "2"));
    }

    @Test
    public void shouldNotDestroySegmentWithNegativeId() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.negativeIdSegment.destroy());
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreClosed() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        KeyValueIterator range0 = this.segment0.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        KeyValueIterator all0 = this.segment0.all();
        KeyValueIterator range1 = this.segment1.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        KeyValueIterator rangeNegative = this.negativeIdSegment.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        Assertions.assertTrue((boolean)range0.hasNext());
        Assertions.assertTrue((boolean)all0.hasNext());
        Assertions.assertTrue((boolean)range1.hasNext());
        Assertions.assertTrue((boolean)rangeNegative.hasNext());
        this.segment0.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> range0.hasNext());
        Assertions.assertThrows(InvalidStateStoreException.class, () -> all0.hasNext());
        Assertions.assertTrue((boolean)range1.hasNext());
        Assertions.assertTrue((boolean)rangeNegative.hasNext());
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreWithNegativeIdClosed() {
        KeyValue kv0 = new KeyValue((Object)"0", (Object)"zero");
        KeyValue kv1 = new KeyValue((Object)"1", (Object)"one");
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment0.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.segment1.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv0.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv0.value));
        this.negativeIdSegment.put(new Bytes(LogicalKeyValueSegmentTest.serializeBytes((String)kv1.key)), LogicalKeyValueSegmentTest.serializeBytes((String)kv1.value));
        KeyValueIterator rangeNegative = this.negativeIdSegment.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        KeyValueIterator allNegative = this.negativeIdSegment.all();
        KeyValueIterator range0 = this.segment0.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        KeyValueIterator range1 = this.segment1.range(null, new Bytes(LogicalKeyValueSegmentTest.serializeBytes("1")));
        Assertions.assertTrue((boolean)rangeNegative.hasNext());
        Assertions.assertTrue((boolean)allNegative.hasNext());
        Assertions.assertTrue((boolean)range0.hasNext());
        Assertions.assertTrue((boolean)range1.hasNext());
        this.negativeIdSegment.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> rangeNegative.hasNext());
        Assertions.assertThrows(InvalidStateStoreException.class, () -> allNegative.hasNext());
        Assertions.assertTrue((boolean)range0.hasNext());
        Assertions.assertTrue((boolean)range1.hasNext());
    }

    private static byte[] serializeBytes(String s) {
        return STRING_SERIALIZER.serialize(null, (Object)s);
    }

    private static String getAndDeserialize(LogicalKeyValueSegment segment, String key) {
        return (String)STRING_DESERIALIZER.deserialize(null, segment.get(new Bytes(LogicalKeyValueSegmentTest.serializeBytes(key))));
    }

    private static List<KeyValue<String, String>> getDeserializedList(KeyValueIterator<Bytes, byte[]> iter) {
        List bytes = Utils.toList(iter);
        return bytes.stream().map(kv -> new KeyValue((Object)((Bytes)kv.key).toString(), (Object)((String)STRING_DESERIALIZER.deserialize(null, (byte[])kv.value)))).collect(Collectors.toList());
    }
}

