/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheKeyValueBytesStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MergedSortedCacheKeyValueBytesStoreIteratorTest {
    private final String namespace = "0.0-one";
    private KeyValueStore<Bytes, byte[]> store;
    private ThreadCache cache;

    @BeforeEach
    public void setUp() {
        this.store = new InMemoryKeyValueStore("0.0-one");
        this.cache = new ThreadCache(new LogContext("testCache "), 10000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
    }

    @Test
    public void shouldIterateOverRange() {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}};
        for (int i = 0; i < bytes.length; i += 2) {
            this.store.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[i + 1]), new LRUCacheEntry(bytes[i + 1]));
        }
        Bytes from = Bytes.wrap((byte[])new byte[]{2});
        Bytes to = Bytes.wrap((byte[])new byte[]{9});
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", this.store.range((Object)from, (Object)to));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range("0.0-one", from, to);
        MergedSortedCacheKeyValueBytesStoreIterator iterator = new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, true);
        byte[][] values = new byte[8][];
        int index = 0;
        int bytesIndex = 2;
        while (iterator.hasNext()) {
            byte[] value = (byte[])iterator.next().value;
            values[index++] = value;
            Assertions.assertArrayEquals((byte[])bytes[bytesIndex++], (byte[])value);
        }
        iterator.close();
    }

    @Test
    public void shouldReverseIterateOverRange() {
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}};
        for (int i = 0; i < bytes.length; i += 2) {
            this.store.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[i + 1]), new LRUCacheEntry(bytes[i + 1]));
        }
        Bytes from = Bytes.wrap((byte[])new byte[]{2});
        Bytes to = Bytes.wrap((byte[])new byte[]{9});
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", this.store.reverseRange((Object)from, (Object)to));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.reverseRange("0.0-one", from, to);
        MergedSortedCacheKeyValueBytesStoreIterator iterator = new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, false);
        byte[][] values = new byte[8][];
        int index = 0;
        int bytesIndex = 9;
        while (iterator.hasNext()) {
            byte[] value = (byte[])iterator.next().value;
            values[index++] = value;
            Assertions.assertArrayEquals((byte[])bytes[bytesIndex--], (byte[])value);
        }
        iterator.close();
    }

    @Test
    public void shouldSkipLargerDeletedCacheValue() {
        byte[][] bytes = new byte[][]{{0}, {1}};
        this.store.put((Object)Bytes.wrap((byte[])bytes[0]), (Object)bytes[0]);
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[1]), new LRUCacheEntry(null));
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertArrayEquals((byte[])bytes[0], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldSkipSmallerDeletedCachedValue() {
        byte[][] bytes = new byte[][]{{0}, {1}};
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[0]), new LRUCacheEntry(null));
        this.store.put((Object)Bytes.wrap((byte[])bytes[1]), (Object)bytes[1]);
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertArrayEquals((byte[])bytes[1], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldIgnoreIfDeletedInCacheButExistsInStore() {
        byte[][] bytes = new byte[][]{{0}};
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[0]), new LRUCacheEntry(null));
        this.store.put((Object)Bytes.wrap((byte[])bytes[0]), (Object)bytes[0]);
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldNotHaveNextIfAllCachedItemsDeleted() {
        byte[][] bytes;
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}}) {
            Bytes aBytes = Bytes.wrap((byte[])aByte);
            this.store.put((Object)aBytes, (Object)aByte);
            this.cache.put("0.0-one", aBytes, new LRUCacheEntry(null));
        }
        Assertions.assertFalse((boolean)this.createIterator().hasNext());
    }

    @Test
    public void shouldNotHaveNextIfOnlyCacheItemsAndAllDeleted() {
        byte[][] bytes;
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}}) {
            this.cache.put("0.0-one", Bytes.wrap((byte[])aByte), new LRUCacheEntry(null));
        }
        Assertions.assertFalse((boolean)this.createIterator().hasNext());
    }

    @Test
    public void shouldIterateCacheOnly() {
        byte[][] bytes;
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}}) {
            this.cache.put("0.0-one", Bytes.wrap((byte[])aByte), new LRUCacheEntry(aByte));
        }
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertArrayEquals((byte[])bytes[0], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[1], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[2], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldIterateStoreOnly() {
        byte[][] bytes;
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}}) {
            this.store.put((Object)Bytes.wrap((byte[])aByte), (Object)aByte);
        }
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertArrayEquals((byte[])bytes[0], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[1], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[2], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldSkipAllDeletedFromCache() {
        byte[][] bytes;
        for (byte[] aByte : bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}}) {
            Bytes aBytes = Bytes.wrap((byte[])aByte);
            this.store.put((Object)aBytes, (Object)aByte);
        }
        this.cache.put("0.0-one", Bytes.wrap((byte[])new byte[]{-1}), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[1]), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[2]), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[3]), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[8]), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])bytes[11]), new LRUCacheEntry(null));
        this.cache.put("0.0-one", Bytes.wrap((byte[])new byte[]{14}), new LRUCacheEntry(null));
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertArrayEquals((byte[])bytes[0], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[4], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[5], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[6], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[7], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[9], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertArrayEquals((byte[])bytes[10], (byte[])((Bytes)iterator.next().key).get());
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldNotHaveNextIfBothIteratorsInitializedEmpty() {
        try (MergedSortedCacheKeyValueBytesStoreIterator iterator = this.createIterator();){
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void shouldPeekNextKey() {
        InMemoryKeyValueStore kv = new InMemoryKeyValueStore("one");
        ThreadCache cache = new ThreadCache(new LogContext("testCache "), 1000000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}};
        for (int i = 0; i < bytes.length - 1; i += 2) {
            kv.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            cache.put("0.0-one", Bytes.wrap((byte[])bytes[i + 1]), new LRUCacheEntry(bytes[i + 1]));
        }
        Bytes from = Bytes.wrap((byte[])new byte[]{2});
        Bytes to = Bytes.wrap((byte[])new byte[]{9});
        KeyValueIterator storeIterator = kv.range((Object)from, (Object)to);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = cache.range("0.0-one", from, to);
        MergedSortedCacheKeyValueBytesStoreIterator iterator = new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator)cacheIterator, storeIterator, true);
        byte[][] values = new byte[8][];
        int index = 0;
        int bytesIndex = 2;
        while (iterator.hasNext()) {
            byte[] keys = ((Bytes)iterator.peekNextKey()).get();
            values[index++] = keys;
            Assertions.assertArrayEquals((byte[])bytes[bytesIndex++], (byte[])keys);
            iterator.next();
        }
        iterator.close();
    }

    @Test
    public void shouldPeekNextKeyReverse() {
        InMemoryKeyValueStore kv = new InMemoryKeyValueStore("one");
        ThreadCache cache = new ThreadCache(new LogContext("testCache "), 1000000L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        byte[][] bytes = new byte[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}};
        for (int i = 0; i < bytes.length - 1; i += 2) {
            kv.put((Object)Bytes.wrap((byte[])bytes[i]), (Object)bytes[i]);
            cache.put("0.0-one", Bytes.wrap((byte[])bytes[i + 1]), new LRUCacheEntry(bytes[i + 1]));
        }
        Bytes from = Bytes.wrap((byte[])new byte[]{2});
        Bytes to = Bytes.wrap((byte[])new byte[]{9});
        KeyValueIterator storeIterator = kv.reverseRange((Object)from, (Object)to);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = cache.reverseRange("0.0-one", from, to);
        MergedSortedCacheKeyValueBytesStoreIterator iterator = new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator)cacheIterator, storeIterator, false);
        byte[][] values = new byte[8][];
        int index = 0;
        int bytesIndex = 9;
        while (iterator.hasNext()) {
            byte[] keys = ((Bytes)iterator.peekNextKey()).get();
            values[index++] = keys;
            Assertions.assertArrayEquals((byte[])bytes[bytesIndex--], (byte[])keys);
            iterator.next();
        }
        iterator.close();
    }

    private MergedSortedCacheKeyValueBytesStoreIterator createIterator() {
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.all("0.0-one");
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", this.store.all());
        return new MergedSortedCacheKeyValueBytesStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, true);
    }
}

