/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MergedSortedCacheWrappedSessionStoreIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private final Bytes storeKey = Bytes.wrap((byte[])"a".getBytes());
    private final Bytes cacheKey = Bytes.wrap((byte[])"b".getBytes());
    private final SessionWindow storeWindow = new SessionWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow), (Object)this.storeKey.get())).iterator();
    private final SessionWindow cacheWindow = new SessionWindow(10L, 20L);
    private final Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs = Collections.singleton(KeyValue.pair((Object)SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(SessionKeySchema.toBinary((Windowed)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow))), (Object)new LRUCacheEntry(this.cacheKey.get()))).iterator();

    @Test
    public void shouldHaveNextFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldHaveNextFromReverseStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow), (Object)this.storeKey.get())));
    }

    @Test
    public void shouldGetNextFromReverseStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow), (Object)this.storeKey.get())));
    }

    @Test
    public void shouldPeekNextKeyFromStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat((Object)((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow)));
    }

    @Test
    public void shouldPeekNextKeyFromReverseStore() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat((Object)((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow)));
    }

    @Test
    public void shouldHaveNextFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldHaveNextFromReverseCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @Test
    public void shouldGetNextFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow), (Object)this.cacheKey.get())));
    }

    @Test
    public void shouldGetNextFromReverseCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat((Object)mergeIterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow), (Object)this.cacheKey.get())));
    }

    @Test
    public void shouldPeekNextKeyFromCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat((Object)((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow)));
    }

    @Test
    public void shouldPeekNextKeyFromReverseCache() {
        MergedSortedCacheSessionStoreIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat((Object)((Windowed)mergeIterator.peekNextKey()), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow)));
    }

    @Test
    public void shouldIterateBothStoreAndCache() {
        MergedSortedCacheSessionStoreIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, true);
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow), (Object)this.storeKey.get())));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow), (Object)this.cacheKey.get())));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldReverseIterateBothStoreAndCache() {
        MergedSortedCacheSessionStoreIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, false);
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.cacheKey, (Window)this.cacheWindow), (Object)this.cacheKey.get())));
        MatcherAssert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)this.storeKey, (Window)this.storeWindow), (Object)this.storeKey.get())));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private MergedSortedCacheSessionStoreIterator createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs, boolean forward) {
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator cacheIterator = new DelegatingPeekingKeyValueIterator("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheSessionStoreIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, SINGLE_SEGMENT_CACHE_FUNCTION, forward);
    }
}

