/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.Iterator;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class MergedSortedCacheWrappedWindowStoreKeyValueIteratorTest {
    private static final SegmentedCacheFunction SINGLE_SEGMENT_CACHE_FUNCTION = new SegmentedCacheFunction(null, -1L){

        public long segmentId(Bytes key) {
            return 0L;
        }
    };
    private static final int WINDOW_SIZE = 10;
    private final String storeKey = "a";
    private final String cacheKey = "b";
    private final TimeWindow storeWindow = new TimeWindow(0L, 1L);
    private final Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs = Collections.singleton(KeyValue.pair((Object)new Windowed((Object)Bytes.wrap((byte[])"a".getBytes()), (Window)this.storeWindow), (Object)"a".getBytes())).iterator();
    private final TimeWindow cacheWindow = new TimeWindow(10L, 20L);
    private Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs;
    private final Deserializer<String> deserializer = Serdes.String().deserializer();
    private StoreKeySerializer<String> storeKeySerializer;
    private MergedSortedCacheWindowStoreKeyValueIterator.StoreKeyToWindowKey storeKeyToWindowKey;
    private MergedSortedCacheWindowStoreKeyValueIterator.WindowKeyToBytes windowKeyToBytes;

    public void setUp(SchemaType schemaType) {
        switch (schemaType.ordinal()) {
            case 1: {
                this.storeKeySerializer = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = PrefixedWindowKeySchemas.KeyFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            case 0: {
                this.storeKeySerializer = WindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = WindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = WindowKeySchema::toStoreKeyBinary;
                break;
            }
            case 2: {
                this.storeKeySerializer = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
                this.storeKeyToWindowKey = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::fromStoreKey;
                this.windowKeyToBytes = PrefixedWindowKeySchemas.TimeFirstWindowKeySchema::toStoreKeyBinary;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown schemaType: " + String.valueOf((Object)schemaType));
            }
        }
        this.cacheKvs = Collections.singleton(KeyValue.pair((Object)SINGLE_SEGMENT_CACHE_FUNCTION.cacheKey(this.storeKeySerializer.serialize((Windowed<String>)new Windowed((Object)"b", (Window)this.cacheWindow), 0, new StateSerdes("dummy", Serdes.String(), Serdes.ByteArray()))), (Object)new LRUCacheEntry("b".getBytes()))).iterator();
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldHaveNextFromStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldHaveNextFromReverseStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldGetNextFromStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldGetNextFromReverseStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldPeekNextKeyFromStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), false);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"a", (Window)this.storeWindow)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldPeekNextKeyFromReverseStore(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(this.storeKvs, Collections.emptyIterator(), true);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"a", (Window)this.storeWindow)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldHaveNextFromCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldHaveNextFromReverseCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        Assertions.assertTrue((boolean)mergeIterator.hasNext());
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldGetNextFromCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldGetNextFromReverseCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)mergeIterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldPeekNextKeyFromCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"b", (Window)this.cacheWindow)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldPeekNextKeyFromReverseCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator mergeIterator = this.createIterator(Collections.emptyIterator(), this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertWindowedKey((Windowed<Bytes>)((Windowed)mergeIterator.peekNextKey())), (Matcher)CoreMatchers.equalTo((Object)new Windowed((Object)"b", (Window)this.cacheWindow)));
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldIterateBothStoreAndCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, true);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @ParameterizedTest
    @EnumSource(value=SchemaType.class)
    public void shouldReverseIterateBothStoreAndCache(SchemaType schemaType) {
        this.setUp(schemaType);
        MergedSortedCacheWindowStoreKeyValueIterator iterator = this.createIterator(this.storeKvs, this.cacheKvs, false);
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"b", (Window)this.cacheWindow), (Object)"b")));
        MatcherAssert.assertThat(this.convertKeyValuePair((KeyValue<Windowed<Bytes>, byte[]>)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)KeyValue.pair((Object)new Windowed((Object)"a", (Window)this.storeWindow), (Object)"a")));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private KeyValue<Windowed<String>, String> convertKeyValuePair(KeyValue<Windowed<Bytes>, byte[]> next) {
        String value = (String)this.deserializer.deserialize("", (byte[])next.value);
        return KeyValue.pair(this.convertWindowedKey((Windowed<Bytes>)((Windowed)next.key)), (Object)value);
    }

    private Windowed<String> convertWindowedKey(Windowed<Bytes> bytesWindowed) {
        String key = (String)this.deserializer.deserialize("", ((Bytes)bytesWindowed.key()).get());
        return new Windowed((Object)key, bytesWindowed.window());
    }

    private MergedSortedCacheWindowStoreKeyValueIterator createIterator(Iterator<KeyValue<Windowed<Bytes>, byte[]>> storeKvs, Iterator<KeyValue<Bytes, LRUCacheEntry>> cacheKvs, boolean forward) {
        DelegatingPeekingKeyValueIterator storeIterator = new DelegatingPeekingKeyValueIterator("store", new KeyValueIteratorStub(storeKvs));
        DelegatingPeekingKeyValueIterator cacheIterator = new DelegatingPeekingKeyValueIterator("cache", new KeyValueIteratorStub(cacheKvs));
        return new MergedSortedCacheWindowStoreKeyValueIterator((PeekingKeyValueIterator)cacheIterator, (KeyValueIterator)storeIterator, new StateSerdes("name", Serdes.Bytes(), Serdes.ByteArray()), 10L, SINGLE_SEGMENT_CACHE_FUNCTION, forward, this.storeKeyToWindowKey, this.windowKeyToBytes);
    }

    private static enum SchemaType {
        WINDOW_KEY_SCHEMA,
        KEY_FIRST_SCHEMA,
        TIME_FIRST_SCHEMA;

    }

    @FunctionalInterface
    private static interface StoreKeySerializer<K> {
        public Bytes serialize(Windowed<K> var1, int var2, StateSerdes<K, ?> var3);
    }
}

