/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.test.KeyValueIteratorStub;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class MeteredKeyValueStoreTest {
    private static final String APPLICATION_ID = "test-app";
    private static final String STORE_NAME = "store-name";
    private static final String STORE_TYPE = "scope";
    private static final String STORE_LEVEL_GROUP = "stream-state-metrics";
    private static final String CHANGELOG_TOPIC = "changelog-topic";
    private static final String THREAD_ID_TAG_KEY = "thread-id";
    private static final String KEY = "key";
    private static final Bytes KEY_BYTES = Bytes.wrap((byte[])"key".getBytes());
    private static final String VALUE = "value";
    private static final byte[] VALUE_BYTES = "value".getBytes();
    private static final KeyValue<Bytes, byte[]> BYTE_KEY_VALUE_PAIR = KeyValue.pair((Object)KEY_BYTES, (Object)VALUE_BYTES);
    private final String threadId = Thread.currentThread().getName();
    private final TaskId taskId = new TaskId(0, 0, "My-Topology");
    @Mock
    private KeyValueStore<Bytes, byte[]> inner;
    @Mock
    private InternalProcessorContext<?, ?> context;
    private MeteredKeyValueStore<String, String> metered;
    private final Metrics metrics = new Metrics();
    private Map<String, String> tags;
    private MockTime mockTime;

    public void setUpWithoutContext() {
        MockTime mockTime;
        this.mockTime = mockTime = new MockTime();
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)mockTime, Serdes.String(), Serdes.String());
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        this.tags = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)THREAD_ID_TAG_KEY, (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)this.taskId.toString()), Utils.mkEntry((Object)"scope-state-id", (Object)STORE_NAME)});
    }

    private void setUp() {
        this.setUpWithoutContext();
        this.metrics.config().recordLevel(Sensor.RecordingLevel.DEBUG);
        Mockito.when((Object)this.context.applicationId()).thenReturn((Object)APPLICATION_ID);
        Mockito.when((Object)this.context.metrics()).thenReturn((Object)new StreamsMetricsImpl(this.metrics, "test", "processId", (Time)this.mockTime));
        Mockito.when((Object)this.context.taskId()).thenReturn((Object)this.taskId);
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn((Object)CHANGELOG_TOPIC);
        Mockito.when((Object)this.inner.name()).thenReturn((Object)STORE_NAME);
    }

    private void init() {
        this.metered.init(this.context, this.metered);
    }

    @Test
    public void shouldDelegateInit() {
        this.setUp();
        MeteredKeyValueStore outer = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).init(this.context, (StateStore)outer);
        outer.init(this.context, (StateStore)outer);
    }

    @Test
    public void shouldPassChangelogTopicNameToStateStoreSerde() {
        this.setUp();
        this.doShouldPassChangelogTopicNameToStateStoreSerde(CHANGELOG_TOPIC);
    }

    @Test
    public void shouldPassDefaultChangelogTopicNameToStateStoreSerdeIfLoggingDisabled() {
        this.setUp();
        String defaultChangelogTopicName = ProcessorStateManager.storeChangelogTopic((String)APPLICATION_ID, (String)STORE_NAME, (String)this.taskId.topologyName());
        Mockito.when((Object)this.context.changelogFor(STORE_NAME)).thenReturn(null);
        this.doShouldPassChangelogTopicNameToStateStoreSerde(defaultChangelogTopicName);
    }

    private void doShouldPassChangelogTopicNameToStateStoreSerde(String topic) {
        Serde keySerde = (Serde)Mockito.mock(Serde.class);
        Serializer keySerializer = (Serializer)Mockito.mock(Serializer.class);
        Serde valueSerde = (Serde)Mockito.mock(Serde.class);
        Deserializer valueDeserializer = (Deserializer)Mockito.mock(Deserializer.class);
        Serializer valueSerializer = (Serializer)Mockito.mock(Serializer.class);
        Mockito.when((Object)keySerde.serializer()).thenReturn((Object)keySerializer);
        Mockito.when((Object)keySerializer.serialize(topic, (Object)KEY)).thenReturn((Object)KEY.getBytes());
        Mockito.when((Object)valueSerde.deserializer()).thenReturn((Object)valueDeserializer);
        Mockito.when((Object)((String)valueDeserializer.deserialize(topic, VALUE_BYTES))).thenReturn((Object)VALUE);
        Mockito.when((Object)valueSerde.serializer()).thenReturn((Object)valueSerializer);
        Mockito.when((Object)valueSerializer.serialize(topic, (Object)VALUE)).thenReturn((Object)VALUE_BYTES);
        Mockito.when((Object)((byte[])this.inner.get((Object)KEY_BYTES))).thenReturn((Object)VALUE_BYTES);
        this.metered = new MeteredKeyValueStore(this.inner, STORE_TYPE, (Time)new MockTime(), keySerde, valueSerde);
        this.metered.init(this.context, this.metered);
        this.metered.get((Object)KEY);
        this.metered.put((Object)KEY, (Object)VALUE);
    }

    @Test
    public void testMetrics() {
        this.setUp();
        this.init();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.streams");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics.addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,%s=%s,task-id=%s,%s-state-id=%s", STORE_LEVEL_GROUP, THREAD_ID_TAG_KEY, this.threadId, this.taskId, STORE_TYPE, STORE_NAME)));
    }

    @Test
    public void shouldRecordRestoreLatencyOnInit() {
        this.setUp();
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).init(this.context, this.metered);
        this.init();
        KafkaMetric metric = this.metric("restore-rate");
        MatcherAssert.assertThat((Object)((Double)metric.metricValue()), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void shouldWriteBytesToInnerStoreAndRecordPutMetric() {
        this.setUp();
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).put((Object)KEY_BYTES, (Object)VALUE_BYTES);
        this.init();
        this.metered.put((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetBytesFromInnerStoreAndReturnGetMetric() {
        this.setUp();
        Mockito.when((Object)((byte[])this.inner.get((Object)KEY_BYTES))).thenReturn((Object)VALUE_BYTES);
        this.init();
        MatcherAssert.assertThat((Object)((String)this.metered.get((Object)KEY)), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        KafkaMetric metric = this.metric("get-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldPutIfAbsentAndRecordPutIfAbsentMetric() {
        this.setUp();
        Mockito.when((Object)((byte[])this.inner.putIfAbsent((Object)KEY_BYTES, (Object)VALUE_BYTES))).thenReturn(null);
        this.init();
        this.metered.putIfAbsent((Object)KEY, (Object)VALUE);
        KafkaMetric metric = this.metric("put-if-absent-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldPutAllToInnerStoreAndRecordPutAllMetric() {
        this.setUp();
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).putAll((List)ArgumentMatchers.any(List.class));
        this.init();
        this.metered.putAll(Collections.singletonList(KeyValue.pair((Object)KEY, (Object)VALUE)));
        KafkaMetric metric = this.metric("put-all-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldDeleteFromInnerStoreAndRecordDeleteMetric() {
        this.setUp();
        Mockito.when((Object)((byte[])this.inner.delete((Object)KEY_BYTES))).thenReturn((Object)VALUE_BYTES);
        this.init();
        this.metered.delete((Object)KEY);
        KafkaMetric metric = this.metric("delete-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetRangeFromInnerStoreAndRecordRangeMetric() {
        this.setUp();
        Mockito.when((Object)this.inner.range((Object)KEY_BYTES, (Object)KEY_BYTES)).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.range((Object)KEY, (Object)KEY);
        MatcherAssert.assertThat((Object)((String)((KeyValue)iterator.next()).value), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric("range-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldGetAllFromInnerStoreAndRecordAllMetric() {
        this.setUp();
        Mockito.when((Object)this.inner.all()).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.all();
        MatcherAssert.assertThat((Object)((String)((KeyValue)iterator.next()).value), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.close();
        KafkaMetric metric = this.metric(new MetricName("all-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldFlushInnerWhenFlushTimeRecords() {
        this.setUp();
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).flush();
        this.init();
        this.metered.flush();
        KafkaMetric metric = this.metric("flush-rate");
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldSetFlushListenerOnWrappedCachingStore() {
        this.setUpWithoutContext();
        CachedKeyValueStore cachedKeyValueStore = (CachedKeyValueStore)Mockito.mock(CachedKeyValueStore.class);
        Mockito.when((Object)cachedKeyValueStore.setFlushListener((CacheFlushListener)ArgumentMatchers.any(CacheFlushListener.class), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)true);
        this.metered = new MeteredKeyValueStore((KeyValueStore)cachedKeyValueStore, STORE_TYPE, (Time)new MockTime(), Serdes.String(), Serdes.String());
        Assertions.assertTrue((boolean)this.metered.setFlushListener(null, false));
    }

    @Test
    public void shouldNotThrowNullPointerExceptionIfGetReturnsNull() {
        this.setUp();
        Mockito.when((Object)((byte[])this.inner.get((Object)Bytes.wrap((byte[])"a".getBytes())))).thenReturn(null);
        this.init();
        Assertions.assertNull((Object)this.metered.get((Object)"a"));
    }

    @Test
    public void shouldNotSetFlushListenerOnWrappedNoneCachingStore() {
        this.setUpWithoutContext();
        Assertions.assertFalse((boolean)this.metered.setFlushListener(null, false));
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.setUp();
        ((KeyValueStore)Mockito.doNothing().when(this.inner)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        this.metered.close();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldRemoveMetricsEvenIfWrappedStoreThrowsOnClose() {
        this.setUp();
        ((KeyValueStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Oops!")}).when(this.inner)).close();
        this.init();
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assertions.assertThrows(RuntimeException.class, () -> this.metered.close());
        MatcherAssert.assertThat(this.storeMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldThrowNullPointerOnGetIfKeyIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.get(null));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfKeyIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.put(null, (Object)VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnPutIfAbsentIfKeyIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.putIfAbsent(null, (Object)VALUE));
    }

    @Test
    public void shouldThrowNullPointerOnDeleteIfKeyIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.delete(null));
    }

    @Test
    public void shouldThrowNullPointerOnPutAllIfAnyKeyIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.putAll(Collections.singletonList(KeyValue.pair(null, (Object)VALUE))));
    }

    @Test
    public void shouldThrowNullPointerOnPrefixScanIfPrefixIsNull() {
        this.setUpWithoutContext();
        StringSerializer stringSerializer = new StringSerializer();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.prefixScan(null, (Serializer)stringSerializer));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfFromIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.range(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnRangeIfToIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.range((Object)"from", null));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfFromIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.reverseRange(null, (Object)"to"));
    }

    @Test
    public void shouldThrowNullPointerOnReverseRangeIfToIsNull() {
        this.setUpWithoutContext();
        Assertions.assertThrows(NullPointerException.class, () -> this.metered.reverseRange((Object)"from", null));
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        this.setUp();
        StringSerializer stringSerializer = new StringSerializer();
        Mockito.when((Object)this.inner.prefixScan((Object)KEY, (Serializer)stringSerializer)).thenReturn(new KeyValueIteratorStub(Collections.singletonList(BYTE_KEY_VALUE_PAIR).iterator()));
        this.init();
        KeyValueIterator iterator = this.metered.prefixScan((Object)KEY, (Serializer)stringSerializer);
        MatcherAssert.assertThat((Object)((String)((KeyValue)iterator.next()).value), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        iterator.close();
        KafkaMetric metric = this.metrics.metric(new MetricName("prefix-scan-rate", STORE_LEVEL_GROUP, "", this.tags));
        Assertions.assertTrue(((Double)metric.metricValue() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldTrackOpenIteratorsMetric() {
        this.setUp();
        StringSerializer stringSerializer = new StringSerializer();
        Mockito.when((Object)this.inner.prefixScan((Object)KEY, (Serializer)stringSerializer)).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric openIteratorsMetric = this.metric("num-open-iterators");
        MatcherAssert.assertThat((Object)openIteratorsMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)0L));
        try (KeyValueIterator unused = this.metered.prefixScan((Object)KEY, (Serializer)stringSerializer);){
            MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)1L));
        }
        MatcherAssert.assertThat((Object)((Long)openIteratorsMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldTimeIteratorDuration() {
        this.setUp();
        Mockito.when((Object)this.inner.all()).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric iteratorDurationAvgMetric = this.metric("iterator-duration-avg");
        KafkaMetric iteratorDurationMaxMetric = this.metric("iterator-duration-max");
        MatcherAssert.assertThat((Object)iteratorDurationAvgMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)iteratorDurationMaxMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        try (KeyValueIterator unused = this.metered.all();){
            this.mockTime.sleep(2L);
        }
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        try (KeyValueIterator iterator = this.metered.all();){
            this.mockTime.sleep(3L);
        }
        MatcherAssert.assertThat((Object)((Double)iteratorDurationAvgMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(2.5 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
        MatcherAssert.assertThat((Object)((Double)iteratorDurationMaxMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)(3.0 * (double)TimeUnit.MILLISECONDS.toNanos(1L))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTrackOldestOpenIteratorTimestamp() {
        this.setUp();
        Mockito.when((Object)this.inner.all()).thenReturn((Object)KeyValueIterators.emptyIterator());
        this.init();
        KafkaMetric oldestIteratorTimestampMetric = this.metric("oldest-iterator-open-since-ms");
        MatcherAssert.assertThat((Object)oldestIteratorTimestampMetric, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)oldestIteratorTimestampMetric.metricValue(), (Matcher)CoreMatchers.nullValue());
        try (KeyValueIterator second = null;){
            long secondTimestamp;
            try (KeyValueIterator unused = this.metered.all();){
                long oldestTimestamp = this.mockTime.milliseconds();
                MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)oldestTimestamp));
                this.mockTime.sleep(100L);
                second = this.metered.all();
                secondTimestamp = this.mockTime.milliseconds();
                MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)oldestTimestamp));
                this.mockTime.sleep(100L);
            }
            MatcherAssert.assertThat((Object)((Long)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.equalTo((Object)secondTimestamp));
        }
        MatcherAssert.assertThat((Object)((Integer)oldestIteratorTimestampMetric.metricValue()), (Matcher)CoreMatchers.nullValue());
    }

    private KafkaMetric metric(MetricName metricName) {
        return this.metrics.metric(metricName);
    }

    private KafkaMetric metric(String name) {
        return this.metrics.metric(new MetricName(name, STORE_LEVEL_GROUP, "", this.tags));
    }

    private List<MetricName> storeMetrics() {
        return this.metrics.metrics().keySet().stream().filter(name -> name.group().equals(STORE_LEVEL_GROUP) && name.tags().equals(this.tags)).collect(Collectors.toList());
    }

    private static interface CachedKeyValueStore
    extends KeyValueStore<Bytes, byte[]>,
    CachedStateStore<byte[], byte[]> {
    }
}

