/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Murmur3Test {
    @Test
    public void testMurmur3_32() {
        HashMap<byte[], Integer> cases = new HashMap<byte[], Integer>();
        cases.put("21".getBytes(), 896581614);
        cases.put("foobar".getBytes(), -328928243);
        cases.put("a-little-bit-long-string".getBytes(), -1479816207);
        cases.put("a-little-bit-longer-string".getBytes(), -153232333);
        cases.put("lkjh234lh9fiuh90y23oiuhsafujhadof229phr9h19h89h8".getBytes(), 13417721);
        cases.put(new byte[]{97, 98, 99}, 461137560);
        int seed = 123;
        for (Map.Entry c : cases.entrySet()) {
            byte[] b = (byte[])c.getKey();
            Assertions.assertEquals(c.getValue(), (Object)Murmur3.hash32((byte[])b, (int)b.length, (int)seed));
        }
    }

    @Test
    public void testMurmur3_128() {
        HashMap<byte[], long[]> cases = new HashMap<byte[], long[]>();
        cases.put("21".getBytes(), new long[]{5857341059704281894L, -5288187638297930763L});
        cases.put("foobar".getBytes(), new long[]{-351361463397418609L, 8959716011862540668L});
        cases.put("a-little-bit-long-string".getBytes(), new long[]{8836256500583638442L, -198172363548498523L});
        cases.put("a-little-bit-longer-string".getBytes(), new long[]{1838346159335108511L, 8794688210320490705L});
        cases.put("lkjh234lh9fiuh90y23oiuhsafujhadof229phr9h19h89h8".getBytes(), new long[]{-4024021876037397259L, -1482317706335141238L});
        cases.put(new byte[]{97, 98, 99}, new long[]{1489494923063836066L, -5440978547625122829L});
        int seed = 123;
        for (Map.Entry c : cases.entrySet()) {
            byte[] b = (byte[])c.getKey();
            long[] result = Murmur3.hash128((byte[])b, (int)0, (int)b.length, (int)seed);
            Assertions.assertArrayEquals((long[])((long[])c.getValue()), (long[])result);
        }
    }
}

