/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.streams.state.internals.RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.AbstractWalFilter;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Logger;
import org.rocksdb.Options;
import org.rocksdb.PlainTableConfig;
import org.rocksdb.RateLimiter;
import org.rocksdb.RemoveEmptyValueCompactionFilter;
import org.rocksdb.SstFileManager;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.VectorMemTableConfig;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WalFilter;
import org.rocksdb.WalProcessingOption;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBufferManager;
import org.rocksdb.util.BytewiseComparator;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapterTest {
    private final List<String> walRelatedMethods = new LinkedList<String>(){
        {
            this.add("setManualWalFlush");
            this.add("setMaxTotalWalSize");
            this.add("setWalBytesPerSync");
            this.add("setWalDir");
            this.add("setWalFilter");
            this.add("setWalRecoveryMode");
            this.add("setWalSizeLimitMB");
            this.add("setWalTtlSeconds");
        }
    };
    private final List<String> ignoreMethods = new LinkedList<String>(){
        {
            this.add("isOwningHandle");
            this.add("getNativeHandle");
            this.add("dispose");
            this.add("wait");
            this.add("equals");
            this.add("getClass");
            this.add("hashCode");
            this.add("notify");
            this.add("notifyAll");
            this.add("toString");
            this.add("getOptionStringFromProps");
            this.add("maxBackgroundCompactions");
            this.add("setMaxBackgroundCompactions");
            this.add("maxBackgroundFlushes");
            this.add("setMaxBackgroundFlushes");
            this.add("tablePropertiesCollectorFactory");
            this.add("setTablePropertiesCollectorFactory");
            this.addAll(RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapterTest.this.walRelatedMethods);
        }
    };

    @Test
    public void shouldOverwriteAllOptionsMethods() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
    }

    @Test
    public void shouldForwardAllDbOptionsCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                DBOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyDBOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDBOptionsMethodCall(Method method) throws Exception {
        DBOptions mockedDbOptions = (DBOptions)Mockito.mock(DBOptions.class);
        Object[] parameters = this.getDBOptionsParameters(method.getParameterTypes());
        try (RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeDbOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(mockedDbOptions, new ColumnFamilyOptions());){
            method.invoke((Object)optionsFacadeDbOptions, parameters);
            Collection invocations = Mockito.mockingDetails((Object)mockedDbOptions).getInvocations();
            Set invokedMethodNames = invocations.stream().map(invocation -> invocation.getMethod().getName()).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)invokedMethodNames.contains(method.getName()), (String)("Should have called DBOptions." + method.getName() + "()"));
        }
    }

    private Object[] getDBOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block30: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block30;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block30;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block30;
                }
                case "java.util.Collection": {
                    parameters[i] = new ArrayList();
                    continue block30;
                }
                case "org.rocksdb.Cache": {
                    parameters[i] = new LRUCache(1L);
                    continue block30;
                }
                case "org.rocksdb.Env": {
                    parameters[i] = Env.getDefault();
                    continue block30;
                }
                case "org.rocksdb.InfoLogLevel": {
                    parameters[i] = InfoLogLevel.FATAL_LEVEL;
                    continue block30;
                }
                case "org.rocksdb.Logger": {
                    parameters[i] = new Logger(new Options()){

                        protected void log(InfoLogLevel infoLogLevel, String logMsg) {
                        }
                    };
                    continue block30;
                }
                case "org.rocksdb.RateLimiter": {
                    parameters[i] = new RateLimiter(1L);
                    continue block30;
                }
                case "org.rocksdb.SstFileManager": {
                    parameters[i] = new SstFileManager(Env.getDefault());
                    continue block30;
                }
                case "org.rocksdb.WALRecoveryMode": {
                    parameters[i] = WALRecoveryMode.AbsoluteConsistency;
                    continue block30;
                }
                case "org.rocksdb.WriteBufferManager": {
                    parameters[i] = new WriteBufferManager(1L, (Cache)new LRUCache(1L));
                    continue block30;
                }
                case "org.rocksdb.AbstractWalFilter": {
                    class TestWalFilter
                    extends AbstractWalFilter {
                        TestWalFilter() {
                        }

                        public void columnFamilyLogNumberMap(Map<Integer, Long> cfLognumber, Map<String, Integer> cfNameId) {
                        }

                        public WalFilter.LogRecordFoundResult logRecordFound(long logNumber, String logFileName, WriteBatch batch, WriteBatch newBatch) {
                            return new WalFilter.LogRecordFoundResult(WalProcessingOption.CONTINUE_PROCESSING, false);
                        }

                        public String name() {
                            return "TestWalFilter";
                        }
                    }
                    parameters[i] = new TestWalFilter();
                    continue block30;
                }
                default: {
                    parameters[i] = parameterTypes[i].getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        return parameters;
    }

    @Test
    public void shouldForwardAllColumnFamilyCalls() throws Exception {
        for (Method method : Options.class.getMethods()) {
            if (this.ignoreMethods.contains(method.getName())) continue;
            try {
                ColumnFamilyOptions.class.getMethod(method.getName(), method.getParameterTypes());
                this.verifyColumnFamilyOptionsMethodCall(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyColumnFamilyOptionsMethodCall(Method method) throws Exception {
        ColumnFamilyOptions mockedColumnFamilyOptions = (ColumnFamilyOptions)Mockito.mock(ColumnFamilyOptions.class);
        Object[] parameters = this.getColumnFamilyOptionsParameters(method.getParameterTypes());
        try (RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter optionsFacadeColumnFamilyOptions = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(new DBOptions(), mockedColumnFamilyOptions);){
            method.invoke((Object)optionsFacadeColumnFamilyOptions, parameters);
            Collection invocations = Mockito.mockingDetails((Object)mockedColumnFamilyOptions).getInvocations();
            Set invokedMethodNames = invocations.stream().map(invocation -> invocation.getMethod().getName()).collect(Collectors.toSet());
            Assertions.assertTrue((boolean)invokedMethodNames.contains(method.getName()), (String)("Should have called ColumnFamilyOptions." + method.getName() + "()"));
        }
    }

    private Object[] getColumnFamilyOptionsParameters(Class<?>[] parameterTypes) throws Exception {
        Object[] parameters = new Object[parameterTypes.length];
        block36: for (int i = 0; i < parameterTypes.length; ++i) {
            switch (parameterTypes[i].getName()) {
                case "boolean": {
                    parameters[i] = true;
                    continue block36;
                }
                case "double": {
                    parameters[i] = 0.0;
                    continue block36;
                }
                case "int": {
                    parameters[i] = 0;
                    continue block36;
                }
                case "long": {
                    parameters[i] = 0L;
                    continue block36;
                }
                case "[I": {
                    parameters[i] = new int[0];
                    continue block36;
                }
                case "java.util.List": {
                    parameters[i] = new ArrayList();
                    continue block36;
                }
                case "org.rocksdb.AbstractCompactionFilter": {
                    parameters[i] = new RemoveEmptyValueCompactionFilter();
                    continue block36;
                }
                case "org.rocksdb.AbstractCompactionFilterFactory": {
                    parameters[i] = new AbstractCompactionFilterFactory<AbstractCompactionFilter<?>>(){

                        public AbstractCompactionFilter<?> createCompactionFilter(AbstractCompactionFilter.Context context) {
                            return null;
                        }

                        public String name() {
                            return "AbstractCompactionFilterFactory";
                        }
                    };
                    continue block36;
                }
                case "org.rocksdb.AbstractComparator": {
                    parameters[i] = new BytewiseComparator(new ComparatorOptions());
                    continue block36;
                }
                case "org.rocksdb.BuiltinComparator": {
                    parameters[i] = BuiltinComparator.BYTEWISE_COMPARATOR;
                    continue block36;
                }
                case "org.rocksdb.CompactionPriority": {
                    parameters[i] = CompactionPriority.ByCompensatedSize;
                    continue block36;
                }
                case "org.rocksdb.CompactionStyle": {
                    parameters[i] = CompactionStyle.UNIVERSAL;
                    continue block36;
                }
                case "org.rocksdb.CompressionType": {
                    parameters[i] = CompressionType.NO_COMPRESSION;
                    continue block36;
                }
                case "org.rocksdb.MemTableConfig": {
                    parameters[i] = new VectorMemTableConfig();
                    continue block36;
                }
                case "org.rocksdb.MergeOperator": {
                    parameters[i] = new StringAppendOperator();
                    continue block36;
                }
                case "org.rocksdb.TableFormatConfig": {
                    parameters[i] = new PlainTableConfig();
                    continue block36;
                }
                default: {
                    parameters[i] = parameterTypes[i].getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        return parameters;
    }

    @Test
    public void shouldLogWarningWhenSettingWalOptions() throws Exception {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class);
             RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter adapter = new RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(new DBOptions(), new ColumnFamilyOptions());){
            for (Method method : RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter.class.getDeclaredMethods()) {
                if (!this.walRelatedMethods.contains(method.getName())) continue;
                method.invoke((Object)adapter, this.getDBOptionsParameters(method.getParameterTypes()));
            }
            List<String> walOptions = Arrays.asList("walDir", "walFilter", "walRecoveryMode", "walBytesPerSync", "walSizeLimitMB", "manualWalFlush", "maxTotalWalSize", "walTtlSeconds");
            Set logMessages = appender.getEvents().stream().filter(e -> e.getLevel().equals("WARN")).map(LogCaptureAppender.Event::getMessage).collect(Collectors.toSet());
            walOptions.forEach(option -> MatcherAssert.assertThat((Object)logMessages, (Matcher)CoreMatchers.hasItem((Object)String.format("WAL is explicitly disabled by Streams in RocksDB. Setting option '%s' will be ignored", option))));
        }
    }
}

