/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SessionStoreFetchTest {
    private static final String STORE_NAME = "store";
    private static final int DATA_SIZE = 5;
    private static final long WINDOW_SIZE = 500L;
    private static final long RETENTION_MS = 10000L;
    private StoreType storeType;
    private boolean enableLogging;
    private boolean enableCaching;
    private boolean forward;
    private LinkedList<KeyValue<Windowed<String>, Long>> expectedRecords;
    private LinkedList<KeyValue<String, String>> records;
    private Properties streamsConfig;
    private String low;
    private String high;
    private String middle;
    private String innerLow;
    private String innerHigh;
    private String innerLowBetween;
    private String innerHighBetween;

    private void setUp(StoreType storeType, boolean enableLogging, boolean enableCaching, boolean forward) {
        this.storeType = storeType;
        this.enableLogging = enableLogging;
        this.enableCaching = enableCaching;
        this.forward = forward;
        this.records = new LinkedList();
        this.expectedRecords = new LinkedList();
        int m = 2;
        for (int i = 0; i < 5; ++i) {
            int index;
            String keyStr = i < 2 ? "a" : "b";
            String key = "key-" + keyStr;
            String key2 = "key-" + keyStr + keyStr;
            String value = "val-" + i;
            KeyValue r = new KeyValue((Object)key, (Object)value);
            KeyValue r2 = new KeyValue((Object)key2, (Object)value);
            this.records.add((KeyValue<String, String>)r);
            this.records.add((KeyValue<String, String>)r2);
            this.high = key;
            if (this.low == null) {
                this.low = key;
            }
            if (i == 2) {
                this.middle = key;
            }
            if (i == 1) {
                this.innerLow = key;
                index = i * 2 - 1;
                this.innerLowBetween = "key-" + index;
            }
            if (i != 3) continue;
            this.innerHigh = key;
            index = i * 2 + 1;
            this.innerHighBetween = "key-" + index;
        }
        Assertions.assertNotNull((Object)this.low);
        Assertions.assertNotNull((Object)this.high);
        Assertions.assertNotNull((Object)this.middle);
        Assertions.assertNotNull((Object)this.innerLow);
        Assertions.assertNotNull((Object)this.innerHigh);
        Assertions.assertNotNull((Object)this.innerLowBetween);
        Assertions.assertNotNull((Object)this.innerHighBetween);
        this.expectedRecords.add((KeyValue<Windowed<String>, Long>)new KeyValue((Object)new Windowed((Object)"key-a", (Window)new SessionWindow(0L, 500L)), (Object)4L));
        this.expectedRecords.add((KeyValue<Windowed<String>, Long>)new KeyValue((Object)new Windowed((Object)"key-aa", (Window)new SessionWindow(0L, 500L)), (Object)4L));
        this.expectedRecords.add((KeyValue<Windowed<String>, Long>)new KeyValue((Object)new Windowed((Object)"key-b", (Window)new SessionWindow(1500L, 2000L)), (Object)6L));
        this.expectedRecords.add((KeyValue<Windowed<String>, Long>)new KeyValue((Object)new Windowed((Object)"key-bb", (Window)new SessionWindow(1500L, 2000L)), (Object)6L));
    }

    public static Stream<Arguments> data() {
        List<StoreType> types = Arrays.asList(StoreType.InMemory, StoreType.RocksDB);
        List<Boolean> logging = Arrays.asList(true, false);
        List<Boolean> caching = Arrays.asList(true, false);
        List<Boolean> forward = Arrays.asList(true, false);
        return SessionStoreFetchTest.buildParameters(types, logging, caching, forward);
    }

    @BeforeEach
    public void setUp() {
        this.streamsConfig = Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"state.dir", (Object)TestUtils.tempDirectory().getPath())}));
    }

    private void verifyNormalQuery(SessionStore<String, Long> stateStore) {
        Iterator<Object> dataIterator;
        try (KeyValueIterator scanIterator = this.forward ? stateStore.fetch((Object)"key-a", (Object)"key-bb") : stateStore.backwardFetch((Object)"key-a", (Object)"key-bb");){
            dataIterator = this.forward ? this.expectedRecords.iterator() : this.expectedRecords.descendingIterator();
            TestUtils.checkEquals((Iterator)scanIterator, dataIterator);
        }
        scanIterator = this.forward ? stateStore.findSessions((Object)"key-a", (Object)"key-bb", 0L, Long.MAX_VALUE) : stateStore.backwardFindSessions((Object)"key-a", (Object)"key-bb", 0L, Long.MAX_VALUE);
        try {
            dataIterator = this.forward ? this.expectedRecords.iterator() : this.expectedRecords.descendingIterator();
            TestUtils.checkEquals((Iterator)scanIterator, dataIterator);
        }
        finally {
            if (scanIterator != null) {
                scanIterator.close();
            }
        }
    }

    private void verifyInfiniteQuery(SessionStore<String, Long> stateStore) {
        Iterator<Object> dataIterator;
        try (KeyValueIterator scanIterator = this.forward ? stateStore.fetch(null, null) : stateStore.backwardFetch(null, null);){
            dataIterator = this.forward ? this.expectedRecords.iterator() : this.expectedRecords.descendingIterator();
            TestUtils.checkEquals((Iterator)scanIterator, dataIterator);
        }
        scanIterator = this.forward ? stateStore.findSessions(null, null, 0L, Long.MAX_VALUE) : stateStore.backwardFindSessions(null, null, 0L, Long.MAX_VALUE);
        try {
            dataIterator = this.forward ? this.expectedRecords.iterator() : this.expectedRecords.descendingIterator();
            TestUtils.checkEquals((Iterator)scanIterator, dataIterator);
        }
        finally {
            if (scanIterator != null) {
                scanIterator.close();
            }
        }
    }

    private void verifyRangeQuery(SessionStore<String, Long> stateStore) {
        this.testRange(stateStore, this.innerLow, this.innerHigh, this.forward);
        this.testRange(stateStore, null, this.middle, this.forward);
        this.testRange(stateStore, this.middle, null, this.forward);
        this.testRange(stateStore, null, this.innerHighBetween, this.forward);
        this.testRange(stateStore, this.innerLowBetween, null, this.forward);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testStoreConfig(StoreType storeType, boolean enableLogging, boolean enableCaching, boolean forward) {
        this.setUp(storeType, enableLogging, enableCaching, forward);
        Materialized<String, Long, SessionStore<Bytes, byte[]>> stateStoreConfig = this.getStoreConfig(this.storeType, this.enableLogging, enableCaching);
        StreamsBuilder builder = new StreamsBuilder();
        KStream stream = builder.stream("input", Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).windowedBy(SessionWindows.ofInactivityGapWithNoGrace((Duration)Duration.ofMillis(500L))).count(stateStoreConfig).toStream().to("output");
        Topology topology = builder.build();
        try (TopologyTestDriver driver = new TopologyTestDriver(topology);){
            TestInputTopic input = driver.createInputTopic("input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            SessionStore stateStore = driver.getSessionStore(STORE_NAME);
            int medium = 4;
            for (int i = 0; i < this.records.size(); ++i) {
                KeyValue<String, String> kv = this.records.get(i);
                long windowStartTime = i < 4 ? 0L : 1500L;
                input.pipeInput((Object)((String)kv.key), (Object)((String)kv.value), windowStartTime);
                input.pipeInput((Object)((String)kv.key), (Object)((String)kv.value), windowStartTime + 500L);
            }
            this.verifyNormalQuery((SessionStore<String, Long>)stateStore);
            this.verifyInfiniteQuery((SessionStore<String, Long>)stateStore);
            this.verifyRangeQuery((SessionStore<String, Long>)stateStore);
        }
    }

    private List<KeyValue<Windowed<String>, Long>> filterList(KeyValueIterator<Windowed<String>, Long> iterator, String from, String to) {
        Predicate<KeyValue> pred = elem -> {
            if (from != null && ((String)((Windowed)elem.key).key()).compareTo(from) < 0) {
                return false;
            }
            if (to != null && ((String)((Windowed)elem.key).key()).compareTo(to) > 0) {
                return false;
            }
            return elem != null;
        };
        return Utils.toList(iterator, pred);
    }

    private void testRange(SessionStore<String, Long> store, String from, String to, boolean forward) {
        try (KeyValueIterator resultIterator = forward ? store.fetch((Object)from, (Object)to) : store.backwardFetch((Object)from, (Object)to);
             KeyValueIterator expectedIterator = forward ? store.fetch(null, null) : store.backwardFetch(null, null);){
            List result = Utils.toList((Iterator)resultIterator);
            List<KeyValue<Windowed<String>, Long>> expected = this.filterList((KeyValueIterator<Windowed<String>, Long>)expectedIterator, from, to);
            MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is(expected));
        }
    }

    private static Stream<Arguments> buildParameters(List<StoreType> types, List<Boolean> logging, List<Boolean> caching, List<Boolean> forward) {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (StoreType type : types) {
            for (boolean log : logging) {
                for (boolean cache : caching) {
                    for (boolean f : forward) {
                        builder.add(Arguments.of((Object[])new Object[]{type, log, cache, f}));
                    }
                }
            }
        }
        return builder.build();
    }

    private Materialized<String, Long, SessionStore<Bytes, byte[]>> getStoreConfig(StoreType type, boolean cachingEnabled, boolean loggingEnabled) {
        Supplier<SessionBytesStoreSupplier> createStore = () -> {
            if (type == StoreType.InMemory) {
                return Stores.inMemorySessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(10000L));
            }
            if (type == StoreType.RocksDB) {
                return Stores.persistentSessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(10000L));
            }
            return Stores.inMemorySessionStore((String)STORE_NAME, (Duration)Duration.ofMillis(10000L));
        };
        SessionBytesStoreSupplier stateStoreSupplier = createStore.get();
        Materialized stateStoreConfig = Materialized.as((SessionBytesStoreSupplier)stateStoreSupplier).withKeySerde(Serdes.String()).withValueSerde(Serdes.Long());
        if (cachingEnabled) {
            stateStoreConfig.withCachingEnabled();
        } else {
            stateStoreConfig.withCachingDisabled();
        }
        if (loggingEnabled) {
            stateStoreConfig.withLoggingEnabled(new HashMap());
        } else {
            stateStoreConfig.withLoggingDisabled();
        }
        return stateStoreConfig;
    }

    private static enum StoreType {
        InMemory,
        RocksDB;

    }
}

