/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.RecordBatchingStateRestoreCallback;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.BufferValue;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueChangeBuffer;
import org.apache.kafka.streams.state.internals.Maybe;
import org.apache.kafka.streams.state.internals.TimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TimeOrderedKeyValueBufferTest<B extends TimeOrderedKeyValueBuffer<String, String, Change<String>>> {
    private static final String APP_ID = "test-app";
    private Function<String, B> bufferSupplier;
    private String testName;

    public static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{"in-memory buffer", name -> new InMemoryTimeOrderedKeyValueChangeBuffer.Builder(name, Serdes.String(), Serdes.serdeFrom((Serializer)new NullRejectingStringSerializer(), (Deserializer)new StringDeserializer())).build()}));
    }

    private void setup(String testName, Function<String, B> bufferSupplier) {
        this.testName = testName + "_" + new Random().nextInt(Integer.MAX_VALUE);
        this.bufferSupplier = bufferSupplier;
    }

    private static MockInternalProcessorContext<?, ?> makeContext() {
        Properties properties = new Properties();
        properties.setProperty("application.id", APP_ID);
        properties.setProperty("bootstrap.servers", "");
        TaskId taskId = new TaskId(0, 0);
        MockInternalProcessorContext context = new MockInternalProcessorContext(properties, taskId, TestUtils.tempDirectory());
        context.setRecordCollector(new MockRecordCollector());
        return context;
    }

    private static void cleanup(MockInternalProcessorContext<?, ?> context, TimeOrderedKeyValueBuffer<String, String, Change<String>> buffer) {
        try {
            buffer.close();
            Utils.delete((File)context.stateDir());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldInit(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldAcceptData(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "2p93nf");
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRejectNullValues(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        try {
            buffer.put(0L, new Record((Object)"asdf", null, 0L), TimeOrderedKeyValueBufferTest.getContext(0L));
            Assertions.fail((String)"expected an exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRemoveData(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "qwer");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        buffer.evictWhile(() -> true, kv -> {});
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)0));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRespectEvictionPredicate(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "eyt");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 0L, "zxcv", "rtg");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> buffer.numRecords() > 1, evicted::add);
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Collections.singletonList(new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"eyt", null), TimeOrderedKeyValueBufferTest.getContext(0L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldTrackCount(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "oin");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 0L, "asdf", "wekjn");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "zxcv", "24inf");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldTrackSize(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "23roni");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)43L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 0L, "asdf", "3l");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)39L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "zxcv", "qfowin");
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldTrackMinTimestamp(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 0L, "asdf", "2093j");
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "zxcv", "3gon4i");
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldEvictOldestAndUpdateSizeAndCountAndMinTimestamp(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 0L, "zxcv", "o23i4");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)42L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 0L, "asdf", "3ng");
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        AtomicInteger callbackCount = new AtomicInteger(0);
        buffer.evictWhile(() -> true, kv -> {
            switch (callbackCount.incrementAndGet()) {
                case 1: {
                    MatcherAssert.assertThat((Object)((String)kv.key()), (Matcher)Matchers.is((Object)"asdf"));
                    MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
                    MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)82L));
                    MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
                    break;
                }
                case 2: {
                    MatcherAssert.assertThat((Object)((String)kv.key()), (Matcher)Matchers.is((Object)"zxcv"));
                    MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)1));
                    MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)42L));
                    MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
                    break;
                }
                default: {
                    Assertions.fail((String)"too many invocations");
                }
            }
        });
        MatcherAssert.assertThat((Object)callbackCount.get(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)Long.MAX_VALUE));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldReturnUndefinedOnPriorValueForNotBufferedKey(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"ASDF"), (Matcher)Matchers.is((Object)Maybe.undefined()));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldReturnPriorValueForBufferedKey(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        ProcessorRecordContext recordContext = TimeOrderedKeyValueBufferTest.getContext(0L);
        context.setRecordContext(recordContext);
        buffer.put(1L, new Record((Object)"A", (Object)new Change((Object)"new-value", (Object)"old-value"), 0L), recordContext);
        buffer.put(1L, new Record((Object)"B", (Object)new Change((Object)"new-value", null), 0L), recordContext);
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"A"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"old-value", (long)-1L))));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"B"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldFlush(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 2L, 0L, "asdf", "2093j");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 1L, 1L, "zxcv", "3gon4i");
        TimeOrderedKeyValueBufferTest.putRecord((TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer, context, 0L, 2L, "deleteme", "deadbeef");
        buffer.evictWhile(() -> buffer.minTimestamp() < 1L, kv -> {});
        buffer.flush();
        List collected = ((MockRecordCollector)context.recordCollector()).collected().stream().map(pr -> {
            KeyValue niceValue;
            if (pr.value() == null) {
                niceValue = null;
            } else {
                byte[] serializedValue = (byte[])pr.value();
                ByteBuffer valueBuffer = ByteBuffer.wrap(serializedValue);
                BufferValue contextualRecord = BufferValue.deserialize((ByteBuffer)valueBuffer);
                long timestamp = valueBuffer.getLong();
                niceValue = new KeyValue((Object)timestamp, (Object)contextualRecord);
            }
            return new ProducerRecord(pr.topic(), pr.partition(), pr.timestamp(), (Object)pr.key().toString(), niceValue, (Iterable)pr.headers());
        }).collect(Collectors.toList());
        MatcherAssert.assertThat(collected, (Matcher)Matchers.is(Arrays.asList(new ProducerRecord("test-app-" + testName + "-changelog", Integer.valueOf(0), null, (Object)"deleteme", null, (Iterable)new RecordHeaders()), new ProducerRecord("test-app-" + testName + "-changelog", Integer.valueOf(0), null, (Object)"zxcv", (Object)new KeyValue((Object)1L, (Object)TimeOrderedKeyValueBufferTest.getBufferValue("3gon4i", 1L)), (Iterable)InMemoryTimeOrderedKeyValueChangeBuffer.CHANGELOG_HEADERS), new ProducerRecord("test-app-" + testName + "-changelog", Integer.valueOf(0), null, (Object)"asdf", (Object)new KeyValue((Object)2L, (Object)TimeOrderedKeyValueBufferTest.getBufferValue("2093j", 0L)), (Iterable)InMemoryTimeOrderedKeyValueChangeBuffer.CHANGELOG_HEADERS))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRestoreOldUnversionedFormat(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        String toDeleteBinaryValue = "0000000000000000FFFFFFFF00000006646F6F6D6564";
        String asdfBinaryValue = "0000000000000002FFFFFFFF0000000471776572";
        String zxcvBinaryValue1 = "00000000000000010000000870726576696F757300000005656F34696D";
        String zxcvBinaryValue2 = "000000000000000100000005656F34696D000000046E657874";
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 0L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000000FFFFFFFF00000006646F6F6D6564"), (Headers)new RecordHeaders(), Optional.empty()), new ConsumerRecord("changelog-topic", 0, 1L, 1L, TimestampType.CREATE_TIME, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000002FFFFFFFF0000000471776572"), (Headers)new RecordHeaders(), Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 2L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("00000000000000010000000870726576696F757300000005656F34696D"), (Headers)new RecordHeaders(), Optional.empty()), new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("000000000000000100000005656F34696D000000046E657874"), (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)172L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null, (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)115L));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"todelete"), (Matcher)Matchers.is((Object)Maybe.undefined()));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"asdf"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"zxcv"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"previous", (long)-1L))));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)new Change((Object)"next", (Object)"eo4im"), new ProcessorRecordContext(3L, 3L, 0, "changelog-topic", (Headers)new RecordHeaders())), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"qwer", null), new ProcessorRecordContext(1L, 1L, 0, "changelog-topic", (Headers)new RecordHeaders())))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRestoreV1Format(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        RecordHeaders v1FlagHeaders = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{1})});
        String toDeleteBinary = "00000000000000000000000000000000000000000000000000000005746F70696300000000FFFFFFFF0000000EFFFFFFFF00000006646F6F6D6564";
        String asdfBinary = "00000000000000020000000000000001000000000000000000000005746F70696300000000FFFFFFFF0000000CFFFFFFFF0000000471776572";
        String zxcvBinary1 = "00000000000000010000000000000002000000000000000000000005746F70696300000000FFFFFFFF000000150000000870726576696F757300000005336F34696D";
        String zxcvBinary2 = "00000000000000010000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000001100000005336F34696D000000046E657874";
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("00000000000000000000000000000000000000000000000000000005746F70696300000000FFFFFFFF0000000EFFFFFFFF00000006646F6F6D6564"), (Headers)v1FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 1L, 9999L, TimestampType.CREATE_TIME, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("00000000000000020000000000000001000000000000000000000005746F70696300000000FFFFFFFF0000000CFFFFFFFF0000000471776572"), (Headers)v1FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 99L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("00000000000000010000000000000002000000000000000000000005746F70696300000000FFFFFFFF000000150000000870726576696F757300000005336F34696D"), (Headers)v1FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 3L, 100L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("00000000000000010000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000001100000005336F34696D000000046E657874"), (Headers)v1FlagHeaders, Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)142L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null, (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)95L));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"todelete"), (Matcher)Matchers.is((Object)Maybe.undefined()));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"asdf"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"zxcv"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"previous", (long)-1L))));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)new Change((Object)"next", (Object)"3o4im"), TimeOrderedKeyValueBufferTest.getContext(3L)), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"qwer", null), TimeOrderedKeyValueBufferTest.getContext(1L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRestoreV2Format(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        RecordHeaders v2FlagHeaders = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{2})});
        String toDeleteBinary = "0000000000000000000000000000000000000005746F70696300000000FFFFFFFF0000000EFFFFFFFF00000006646F6F6D6564FFFFFFFF0000000000000000";
        String asdfBinary = "0000000000000001000000000000000000000005746F70696300000000FFFFFFFF0000000CFFFFFFFF0000000471776572FFFFFFFF0000000000000002";
        String zxcvBinary1 = "0000000000000002000000000000000000000005746F70696300000000FFFFFFFF000000140000000749474E4F52454400000005336F34696D0000000870726576696F75730000000000000001";
        String zxcvBinary2 = "0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000001100000005336F34696D000000046E6578740000000870726576696F75730000000000000001";
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000000000000000000000000000005746F70696300000000FFFFFFFF0000000EFFFFFFFF00000006646F6F6D6564FFFFFFFF0000000000000000"), (Headers)v2FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 1L, 9999L, TimestampType.CREATE_TIME, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000001000000000000000000000005746F70696300000000FFFFFFFF0000000CFFFFFFFF0000000471776572FFFFFFFF0000000000000002"), (Headers)v2FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 99L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000002000000000000000000000005746F70696300000000FFFFFFFF000000140000000749474E4F52454400000005336F34696D0000000870726576696F75730000000000000001"), (Headers)v2FlagHeaders, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 100L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000001100000005336F34696D000000046E6578740000000870726576696F75730000000000000001"), (Headers)v2FlagHeaders, Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)142L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null, (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)95L));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"todelete"), (Matcher)Matchers.is((Object)Maybe.undefined()));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"asdf"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"zxcv"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"previous", (long)-1L))));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)new Change((Object)"next", (Object)"3o4im"), TimeOrderedKeyValueBufferTest.getContext(3L)), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"qwer", null), TimeOrderedKeyValueBufferTest.getContext(1L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRestoreV3FormatWithV2Header(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        RecordHeaders headers = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{2})});
        String toDeleteBinary = "0000000000000000000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000006646F6F6D65640000000000000000";
        String asdfBinary = "0000000000000001000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000004717765720000000000000002";
        String zxcvBinary1 = "0000000000000002000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F75730000000749474E4F52454400000005336F34696D0000000000000001";
        String zxcvBinary2 = "0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F757300000005336F34696D000000046E6578740000000000000001";
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000000000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000006646F6F6D65640000000000000000"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 1L, 9999L, TimestampType.CREATE_TIME, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000001000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000004717765720000000000000002"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 99L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000002000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F75730000000749474E4F52454400000005336F34696D0000000000000001"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 100L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F757300000005336F34696D000000046E6578740000000000000001"), (Headers)headers, Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)142L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null, (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)95L));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"todelete"), (Matcher)Matchers.is((Object)Maybe.undefined()));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"asdf"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"zxcv"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"previous", (long)-1L))));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)new Change((Object)"next", (Object)"3o4im"), TimeOrderedKeyValueBufferTest.getContext(3L)), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"qwer", null), TimeOrderedKeyValueBufferTest.getContext(1L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldRestoreV3Format(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        RecordHeaders headers = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{3})});
        String toDeleteBinary = "0000000000000000000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000006646F6F6D65640000000000000000";
        String asdfBinary = "0000000000000001000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000004717765720000000000000002";
        String zxcvBinary1 = "0000000000000002000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F75730000000749474E4F52454400000005336F34696D0000000000000001";
        String zxcvBinary2 = "0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F757300000005336F34696D000000046E6578740000000000000001";
        stateRestoreCallback.restoreBatch(Arrays.asList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000000000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000006646F6F6D65640000000000000000"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 1L, 9999L, TimestampType.CREATE_TIME, -1, -1, (Object)"asdf".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000001000000000000000000000005746F70696300000000FFFFFFFFFFFFFFFFFFFFFFFF00000004717765720000000000000002"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 99L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000002000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F75730000000749474E4F52454400000005336F34696D0000000000000001"), (Headers)headers, Optional.empty()), new ConsumerRecord("changelog-topic", 0, 2L, 100L, TimestampType.CREATE_TIME, -1, -1, (Object)"zxcv".getBytes(StandardCharsets.UTF_8), (Object)TimeOrderedKeyValueBufferTest.hexStringToByteArray("0000000000000003000000000000000000000005746F70696300000000FFFFFFFF0000000870726576696F757300000005336F34696D000000046E6578740000000000000001"), (Headers)headers, Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)142L));
        stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 3L, 3L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), null, (Headers)new RecordHeaders(), Optional.empty())));
        MatcherAssert.assertThat((Object)buffer.numRecords(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)buffer.minTimestamp(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)buffer.bufferSize(), (Matcher)Matchers.is((Object)95L));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"todelete"), (Matcher)Matchers.is((Object)Maybe.undefined()));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"asdf"), (Matcher)Matchers.is((Object)Maybe.defined(null)));
        MatcherAssert.assertThat((Object)buffer.priorValueForBuffered((Object)"zxcv"), (Matcher)Matchers.is((Object)Maybe.defined((Object)ValueAndTimestamp.make((Object)"previous", (long)-1L))));
        LinkedList evicted = new LinkedList();
        buffer.evictWhile(() -> true, evicted::add);
        MatcherAssert.assertThat(evicted, (Matcher)Matchers.is(Arrays.asList(new TimeOrderedKeyValueBuffer.Eviction((Object)"zxcv", (Object)new Change((Object)"next", (Object)"3o4im"), TimeOrderedKeyValueBufferTest.getContext(3L)), new TimeOrderedKeyValueBuffer.Eviction((Object)"asdf", (Object)new Change((Object)"qwer", null), TimeOrderedKeyValueBufferTest.getContext(1L)))));
        TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void shouldNotRestoreUnrecognizedVersionRecord(String testName, Function<String, B> bufferSupplier) {
        this.setup(testName, bufferSupplier);
        TimeOrderedKeyValueBuffer buffer = (TimeOrderedKeyValueBuffer)bufferSupplier.apply(testName);
        MockInternalProcessorContext<?, ?> context = TimeOrderedKeyValueBufferTest.makeContext();
        buffer.init(context, (StateStore)buffer);
        RecordBatchingStateRestoreCallback stateRestoreCallback = (RecordBatchingStateRestoreCallback)context.stateRestoreCallback(testName);
        context.setRecordContext(new ProcessorRecordContext(0L, 0L, 0, "", (Headers)new RecordHeaders()));
        RecordHeaders unknownFlagHeaders = new RecordHeaders(new Header[]{new RecordHeader("v", new byte[]{-1})});
        byte[] todeleteValue = TimeOrderedKeyValueBufferTest.getBufferValue("doomed", 0L).serialize(0).array();
        try {
            stateRestoreCallback.restoreBatch(Collections.singletonList(new ConsumerRecord("changelog-topic", 0, 0L, 999L, TimestampType.CREATE_TIME, -1, -1, (Object)"todelete".getBytes(StandardCharsets.UTF_8), (Object)ByteBuffer.allocate(8 + todeleteValue.length).putLong(0L).put(todeleteValue).array(), (Headers)unknownFlagHeaders, Optional.empty())));
            Assertions.fail((String)"expected an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            TimeOrderedKeyValueBufferTest.cleanup(context, (TimeOrderedKeyValueBuffer<String, String, Change<String>>)buffer);
        }
    }

    private static void putRecord(TimeOrderedKeyValueBuffer<String, String, Change<String>> buffer, MockInternalProcessorContext<?, ?> context, long streamTime, long recordTimestamp, String key, String value) {
        ProcessorRecordContext recordContext = TimeOrderedKeyValueBufferTest.getContext(recordTimestamp);
        context.setRecordContext(recordContext);
        buffer.put(streamTime, new Record((Object)key, (Object)new Change((Object)value, null), 0L), recordContext);
    }

    private static BufferValue getBufferValue(String value, long timestamp) {
        return new BufferValue(null, null, new StringSerializer().serialize(null, value), TimeOrderedKeyValueBufferTest.getContext(timestamp));
    }

    private static ProcessorRecordContext getContext(long recordTimestamp) {
        return new ProcessorRecordContext(recordTimestamp, 0L, 0, "topic", (Headers)new RecordHeaders());
    }

    private static byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static final class NullRejectingStringSerializer
    extends StringSerializer {
        public byte[] serialize(String topic, String data) {
            if (data == null) {
                throw new IllegalArgumentException("null data not allowed");
            }
            return super.serialize(topic, data);
        }
    }
}

