/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.TimeWindowedDeserializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListenerStub;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.PrefixedWindowKeySchemas;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDbIndexedTimeOrderedWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.ThreadCacheTest;
import org.apache.kafka.streams.state.internals.TimeOrderedCachingWindowStore;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class TimeOrderedWindowStoreTest {
    private static final int MAX_CACHE_SIZE_BYTES = 300;
    private static final long DEFAULT_TIMESTAMP = 10L;
    private static final Long WINDOW_SIZE = 10L;
    private static final long SEGMENT_INTERVAL = 100L;
    private static final String TOPIC = "topic";
    private static final String CACHE_NAMESPACE = "0_0-store-name";
    private InternalMockProcessorContext<?, ?> context;
    private RocksDBTimeOrderedWindowSegmentedBytesStore bytesStore;
    private RocksDBTimeOrderedWindowStore underlyingStore;
    private TimeOrderedCachingWindowStore cachingStore;
    private CacheFlushListenerStub<Windowed<String>, String> cacheListener;
    private ThreadCache cache;
    private PrefixedWindowKeySchemas.TimeFirstWindowKeySchema baseKeySchema;

    public void setUp(boolean hasIndex) {
        this.baseKeySchema = new PrefixedWindowKeySchemas.TimeFirstWindowKeySchema();
        this.bytesStore = new RocksDBTimeOrderedWindowSegmentedBytesStore("test", "metrics-scope", 100L, 100L, hasIndex);
        this.underlyingStore = new RocksDBTimeOrderedWindowStore(this.bytesStore, false, WINDOW_SIZE.longValue());
        TimeWindowedDeserializer keyDeserializer = new TimeWindowedDeserializer((Deserializer)new StringDeserializer(), WINDOW_SIZE);
        keyDeserializer.setIsChangelogTopic(true);
        this.cacheListener = new CacheFlushListenerStub(keyDeserializer, new StringDeserializer());
        this.cachingStore = new TimeOrderedCachingWindowStore((WindowStore)this.underlyingStore, WINDOW_SIZE.longValue(), 100L);
        this.cachingStore.setFlushListener(this.cacheListener, false);
        this.cache = new ThreadCache(new LogContext("testCache "), 300L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics()));
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.cachingStore.init(this.context, (StateStore)this.cachingStore);
    }

    @AfterEach
    public void closeStore() {
        this.cachingStore.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldDelegateInit(boolean hasIndex) {
        this.setUp(hasIndex);
        RocksDBTimeOrderedWindowStore inner = (RocksDBTimeOrderedWindowStore)Mockito.mock(RocksDBTimeOrderedWindowStore.class);
        Mockito.when((Object)inner.hasIndex()).thenReturn((Object)hasIndex);
        TimeOrderedCachingWindowStore outer = new TimeOrderedCachingWindowStore((WindowStore)inner, WINDOW_SIZE.longValue(), 100L);
        Mockito.reset((Object[])new RocksDBTimeOrderedWindowStore[]{inner});
        Mockito.when((Object)inner.name()).thenReturn((Object)"store");
        outer.init(this.context, (StateStore)outer);
        ((RocksDBTimeOrderedWindowStore)Mockito.verify((Object)inner)).init(this.context, (StateStore)outer);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowIfWrongStore(boolean hasIndex) {
        this.setUp(hasIndex);
        RocksDBTimestampedWindowStore innerWrong = (RocksDBTimestampedWindowStore)Mockito.mock(RocksDBTimestampedWindowStore.class);
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new TimeOrderedCachingWindowStore((WindowStore)innerWrong, WINDOW_SIZE.longValue(), 100L));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"TimeOrderedCachingWindowStore only supports RocksDBTimeOrderedWindowStore backed store"));
        RocksDBTimeOrderedWindowStore inner = (RocksDBTimeOrderedWindowStore)Mockito.mock(RocksDBTimeOrderedWindowStore.class);
        new TimeOrderedCachingWindowStore((WindowStore)inner, WINDOW_SIZE.longValue(), 100L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldNotReturnDuplicatesInRanges(boolean hasIndex) {
        int i;
        this.setUp(hasIndex);
        StreamsBuilder builder = new StreamsBuilder();
        StoreBuilder storeBuilder = Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create((String)"store-name", (Duration)Duration.ofHours(1L), (Duration)Duration.ofMinutes(1L), (boolean)false, (boolean)hasIndex), (Serde)Serdes.String(), (Serde)Serdes.String()).withCachingEnabled();
        builder.addStateStore(storeBuilder);
        builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).process(() -> new Processor<String, String, String, String>(){
            private WindowStore<String, ValueAndTimestamp<String>> store;
            private int numRecordsProcessed;
            private ProcessorContext<String, String> context;

            public void init(ProcessorContext<String, String> processorContext) {
                this.context = processorContext;
                this.store = (WindowStore)processorContext.getStateStore("store-name");
                int count = 0;
                try (KeyValueIterator all = this.store.all();){
                    while (all.hasNext()) {
                        ++count;
                        all.next();
                    }
                }
                MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)0));
            }

            public void process(Record<String, String> record) {
                int count = 0;
                try (KeyValueIterator all = this.store.all();){
                    while (all.hasNext()) {
                        ++count;
                        all.next();
                    }
                }
                MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)this.numRecordsProcessed));
                this.store.put((Object)((String)record.value()), (Object)ValueAndTimestamp.make((Object)((String)record.value()), (long)record.timestamp()), record.timestamp());
                ++this.numRecordsProcessed;
                this.context.forward(record);
            }
        }, new String[]{"store-name"});
        Properties streamsConfiguration = new Properties();
        streamsConfiguration.put("auto.offset.reset", "earliest");
        streamsConfiguration.put("default.key.serde", Serdes.StringSerde.class.getName());
        streamsConfiguration.put("default.value.serde", Serdes.StringSerde.class.getName());
        streamsConfiguration.put("state.dir", TestUtils.tempDirectory().getPath());
        streamsConfiguration.put("commit.interval.ms", (Object)10000L);
        Instant initialWallClockTime = Instant.ofEpochMilli(0L);
        TopologyTestDriver driver = new TopologyTestDriver(builder.build(), streamsConfiguration, initialWallClockTime);
        TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer(), initialWallClockTime, Duration.ZERO);
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.advanceWallClockTime(Duration.ofSeconds(10L));
        inputTopic.advanceTime(Duration.ofSeconds(10L));
        for (i = 0; i < 5; ++i) {
            inputTopic.pipeInput((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        }
        driver.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutFetchFromCache(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("a"), 10L), (Matcher)CoreMatchers.equalTo((Object)TimeOrderedWindowStoreTest.bytesValue("a")));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("b"), 10L), (Matcher)CoreMatchers.equalTo((Object)TimeOrderedWindowStoreTest.bytesValue("b")));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("c"), 10L), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("a"), 0L), (Matcher)CoreMatchers.equalTo(null));
        try (WindowStoreIterator a = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));
             WindowStoreIterator b = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)a.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)b.next()), 10L, "b");
            Assertions.assertFalse((boolean)a.hasNext());
            Assertions.assertFalse((boolean)b.hasNext());
            int expectedSize = hasIndex ? 4 : 2;
            Assertions.assertEquals((long)expectedSize, (long)this.cache.size());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldMatchPositionAfterPutWithFlushListener(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.setFlushListener(record -> {}, false);
        this.shouldMatchPositionAfterPut();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldMatchPositionAfterPutWithoutFlushListener(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.setFlushListener(null, false);
        this.shouldMatchPositionAfterPut();
    }

    private void shouldMatchPositionAfterPut() {
        this.context.setRecordContext(new ProcessorRecordContext(0L, 1L, 0, "", (Headers)new RecordHeaders()));
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("key1"), TimeOrderedWindowStoreTest.bytesValue("value1"), 10L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 2L, 0, "", (Headers)new RecordHeaders()));
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("key2"), TimeOrderedWindowStoreTest.bytesValue("value2"), 10L);
        this.context.setRecordContext(new ProcessorRecordContext(0L, 3L, 0, "", (Headers)new RecordHeaders()));
        Assertions.assertEquals((Object)Position.emptyPosition(), (Object)this.cachingStore.getPosition());
        Assertions.assertEquals((Object)Position.emptyPosition(), (Object)this.underlyingStore.getPosition());
        this.cachingStore.flush();
        Assertions.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.cachingStore.getPosition());
        Assertions.assertEquals((Object)Position.fromMap((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"", (Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)0, (Object)2L)}))})), (Object)this.underlyingStore.getPosition());
    }

    private void verifyKeyValue(KeyValue<Long, byte[]> next, long expectedKey, String expectedValue) {
        MatcherAssert.assertThat((Object)((Long)next.key), (Matcher)CoreMatchers.equalTo((Object)expectedKey));
        MatcherAssert.assertThat((Object)((byte[])next.value), (Matcher)CoreMatchers.equalTo((Object)TimeOrderedWindowStoreTest.bytesValue(expectedValue)));
    }

    private static byte[] bytesValue(String value) {
        return value.getBytes();
    }

    private static Bytes bytesKey(String key) {
        return Bytes.wrap((byte[])key.getBytes());
    }

    private String stringFrom(byte[] from) {
        return new StringDeserializer().deserialize("", from);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutFetchRangeFromCache(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
            int expectedSize = hasIndex ? 4 : 2;
            Assertions.assertEquals((long)expectedSize, (long)this.cache.size());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutFetchRangeFromCacheForNullKeyFrom(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch(null, (Object)TimeOrderedWindowStoreTest.bytesKey("d"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b", "c", "d");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutFetchRangeFromCacheForNullKeyTo(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("b"), null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("b", "c", "d", "e");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutFetchRangeFromCacheForNullKeyFromKeyTo(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.fetch(null, null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("a", "b", "c", "d", "e");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyFrom(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch(null, (Object)TimeOrderedWindowStoreTest.bytesKey("c"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("c", "b", "a");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyTo(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("c"), null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("e", "d", "c");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldPutBackwardFetchRangeFromCacheForNullKeyFromKeyTo(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 20L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 30L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 30L);
        try (KeyValueIterator iterator = this.cachingStore.backwardFetch(null, null, Instant.ofEpochMilli(10L), Instant.ofEpochMilli(30L));){
            List<Windowed<Bytes>> expectedKeys = Arrays.asList(new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("e"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("d"), (Window)new TimeWindow(30L, 30L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("c"), (Window)new TimeWindow(20L, 20L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("b"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)));
            List<String> expectedValues = Arrays.asList("e", "d", "c", "b", "a");
            StreamsTestUtils.verifyAllWindowedKeyValues((KeyValueIterator<Windowed<Bytes>, byte[]>)iterator, expectedKeys, expectedValues);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldGetAllFromCache(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("f"), TimeOrderedWindowStoreTest.bytesValue("f"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("g"), TimeOrderedWindowStoreTest.bytesValue("g"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("h"), TimeOrderedWindowStoreTest.bytesValue("h"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.all();){
            String[] array;
            for (String s : array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"}) {
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(s), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), s);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldGetAllBackwardFromCache(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("b"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("c"), TimeOrderedWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("d"), TimeOrderedWindowStoreTest.bytesValue("d"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("e"), TimeOrderedWindowStoreTest.bytesValue("e"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("f"), TimeOrderedWindowStoreTest.bytesValue("f"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("g"), TimeOrderedWindowStoreTest.bytesValue("g"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("h"), TimeOrderedWindowStoreTest.bytesValue("h"), 10L);
        try (KeyValueIterator iterator = this.cachingStore.backwardAll();){
            String[] array;
            for (String s : array = new String[]{"h", "g", "f", "e", "d", "c", "b", "a"}) {
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(s), (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), s);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFetchAllWithinTimestampRange(boolean hasIndex) {
        String str;
        int i;
        this.setUp(hasIndex);
        String[] array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey(array[i2]), TimeOrderedWindowStoreTest.bytesValue(array[i2]), (long)i2);
        }
        try (KeyValueIterator iterator = this.cachingStore.fetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(7L));){
            for (i = 0; i < array.length; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        try (KeyValueIterator iterator1 = this.cachingStore.fetchAll(Instant.ofEpochMilli(2L), Instant.ofEpochMilli(4L));){
            for (i = 2; i <= 4; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator1.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator1.hasNext());
        }
        try (KeyValueIterator iterator2 = this.cachingStore.fetchAll(Instant.ofEpochMilli(5L), Instant.ofEpochMilli(7L));){
            for (i = 5; i <= 7; ++i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator2.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator2.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFetchAllBackwardWithinTimestampRange(boolean hasIndex) {
        String str;
        int i;
        this.setUp(hasIndex);
        String[] array = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey(array[i2]), TimeOrderedWindowStoreTest.bytesValue(array[i2]), (long)i2);
        }
        try (KeyValueIterator iterator = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(0L), Instant.ofEpochMilli(7L));){
            for (i = array.length - 1; i >= 0; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator.hasNext());
        }
        try (KeyValueIterator iterator1 = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(2L), Instant.ofEpochMilli(4L));){
            for (i = 4; i >= 2; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator1.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator1.hasNext());
        }
        try (KeyValueIterator iterator2 = this.cachingStore.backwardFetchAll(Instant.ofEpochMilli(5L), Instant.ofEpochMilli(7L));){
            for (i = 7; i >= 5; --i) {
                str = array[i];
                StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)iterator2.next()), (Windowed<Bytes>)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(str), (Window)new TimeWindow((long)i, (long)i + WINDOW_SIZE)), str);
            }
            Assertions.assertFalse((boolean)iterator2.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFlushEvictedItemsIntoUnderlyingStore(boolean hasIndex) {
        this.setUp(hasIndex);
        int added = this.addItemsToCache();
        try (KeyValueIterator iter = this.bytesStore.fetch(Bytes.wrap((byte[])"0".getBytes(StandardCharsets.UTF_8)), 10L, 10L);){
            KeyValue next = (KeyValue)iter.next();
            Assertions.assertEquals((long)10L, (long)this.baseKeySchema.segmentTimestamp((Bytes)next.key));
            Assertions.assertArrayEquals((byte[])"0".getBytes(), (byte[])((byte[])next.value));
            Assertions.assertFalse((boolean)iter.hasNext());
            Assertions.assertEquals((long)(added - 1), (long)this.cache.size());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldForwardDirtyItemsWhenFlushCalled(boolean hasIndex) {
        this.setUp(hasIndex);
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"a", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldSetFlushListener(boolean hasIndex) {
        this.setUp(hasIndex);
        Assertions.assertTrue((boolean)this.cachingStore.setFlushListener(null, true));
        Assertions.assertTrue((boolean)this.cachingStore.setFlushListener(null, false));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldForwardOldValuesWhenEnabled(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.setFlushListener(this.cacheListener, true);
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull(this.cacheListener.forwarded.get(windowedKey));
        this.cacheListener.forwarded.clear();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldForwardOldValuesWhenDisabled(boolean hasIndex) {
        this.setUp(hasIndex);
        Windowed windowedKey = new Windowed((Object)"1", (Window)new TimeWindow(10L, 10L + WINDOW_SIZE));
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"b", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("c"), 10L);
        this.cachingStore.flush();
        Assertions.assertEquals((Object)"c", (Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).newValue);
        Assertions.assertNull((Object)this.cacheListener.forwarded.get((Object)windowedKey).oldValue);
        this.cacheListener.forwarded.clear();
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), null, 10L);
        this.cachingStore.flush();
        Assertions.assertNull(this.cacheListener.forwarded.get(windowedKey));
        this.cacheListener.forwarded.clear();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldForwardDirtyItemToListenerWhenEvicted(boolean hasIndex) {
        this.setUp(hasIndex);
        int numRecords = this.addItemsToCache();
        Assertions.assertEquals((int)numRecords, (int)this.cacheListener.forwarded.size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldTakeValueFromCacheIfSameTimestampFlushedToRocks(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.flush();
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateAcrossWindows(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateBackwardAcrossWindows(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("a"), 10L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("1"), TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateCacheAndStore(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateBackwardCacheAndStore(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (WindowStoreIterator fetch = this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("1"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L + WINDOW_SIZE, "b");
            this.verifyKeyValue((KeyValue<Long, byte[]>)((KeyValue)fetch.next()), 10L, "a");
            Assertions.assertFalse((boolean)fetch.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateCacheAndStoreKeyRange(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (KeyValueIterator fetchRange = this.cachingStore.fetch((Object)key, (Object)TimeOrderedWindowStoreTest.bytesKey("2"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L + WINDOW_SIZE, 10L + WINDOW_SIZE + WINDOW_SIZE)), "b");
            Assertions.assertFalse((boolean)fetchRange.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldIterateBackwardCacheAndStoreKeyRange(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes key = Bytes.wrap((byte[])"1".getBytes());
        this.bytesStore.put(PrefixedWindowKeySchemas.TimeFirstWindowKeySchema.toStoreKeyBinary((Bytes)key, (long)10L, (int)0), "a".getBytes());
        this.cachingStore.put(key, TimeOrderedWindowStoreTest.bytesValue("b"), 10L + WINDOW_SIZE);
        try (KeyValueIterator fetchRange = this.cachingStore.backwardFetch((Object)key, (Object)TimeOrderedWindowStoreTest.bytesKey("2"), Instant.ofEpochMilli(10L), Instant.ofEpochMilli(10L + WINDOW_SIZE));){
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L + WINDOW_SIZE, 10L + WINDOW_SIZE + WINDOW_SIZE)), "b");
            StreamsTestUtils.verifyWindowedKeyValue((KeyValue<Windowed<Bytes>, byte[]>)((KeyValue)fetchRange.next()), (Windowed<Bytes>)new Windowed((Object)key, (Window)new TimeWindow(10L, 10L + WINDOW_SIZE)), "a");
            Assertions.assertFalse((boolean)fetchRange.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldClearNamespaceCacheOnClose(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 0L);
        int size = hasIndex ? 2 : 1;
        Assertions.assertEquals((long)size, (long)this.cache.size());
        this.cachingStore.close();
        Assertions.assertEquals((long)0L, (long)this.cache.size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowIfTryingToFetchFromClosedCachingStore(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowIfTryingToFetchRangeFromClosedCachingStore(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("b"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowIfTryingToWriteToClosedCachingStore(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.close();
        Assertions.assertThrows(InvalidStateStoreException.class, () -> this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("a"), 0L));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldSkipNonExistBaseKeyInCache(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 0L);
        SegmentedCacheFunction indexCacheFunction = new SegmentedCacheFunction((SegmentedBytesStore.KeySchema)new PrefixedWindowKeySchemas.KeyFirstWindowKeySchema(), 100L);
        Bytes key = TimeOrderedWindowStoreTest.bytesKey("a");
        byte[] value = TimeOrderedWindowStoreTest.bytesValue("0001");
        Bytes cacheIndexKey = indexCacheFunction.cacheKey(PrefixedWindowKeySchemas.KeyFirstWindowKeySchema.toStoreKeyBinary((Bytes)key, (long)1L, (int)0));
        String cacheName = String.valueOf(this.context.taskId()) + "-test";
        this.cache.put(cacheName, cacheIndexKey, new LRUCacheEntry(new byte[0], (Headers)new RecordHeaders(), true, this.context.offset(), this.context.timestamp(), this.context.partition(), ""));
        this.underlyingStore.put(key, value, 1L);
        if (hasIndex) {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0001", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        } else {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0001", 1L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFetchAndIterateOverExactKeys(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0005"), 100L);
        List expected = Arrays.asList(KeyValue.pair((Object)0L, (Object)TimeOrderedWindowStoreTest.bytesValue("0001")), KeyValue.pair((Object)1L, (Object)TimeOrderedWindowStoreTest.bytesValue("0003")), KeyValue.pair((Object)100L, (Object)TimeOrderedWindowStoreTest.bytesValue("0005")));
        List actual = StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(expected, actual);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldBackwardFetchAndIterateOverExactKeys(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0005"), 100L);
        List expected = Arrays.asList(KeyValue.pair((Object)100L, (Object)TimeOrderedWindowStoreTest.bytesValue("0005")), KeyValue.pair((Object)1L, (Object)TimeOrderedWindowStoreTest.bytesValue("0003")), KeyValue.pair((Object)0L, (Object)TimeOrderedWindowStoreTest.bytesValue("0001")));
        List actual = StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE)));
        StreamsTestUtils.verifyKeyValueList(expected, actual);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFetchAndIterateOverKeyRange(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0005"), 100L);
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("aa"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        if (hasIndex) {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        } else {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.fetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldFetchAndIterateOverKeyBackwardRange(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0003"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0005"), 100L);
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("a"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("aa"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        if (!hasIndex) {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L), TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        } else {
            StreamsTestUtils.verifyKeyValueList(Arrays.asList(TimeOrderedWindowStoreTest.windowedPair("a", "0005", 100L), TimeOrderedWindowStoreTest.windowedPair("aa", "0004", 1L), TimeOrderedWindowStoreTest.windowedPair("aa", "0002", 0L), TimeOrderedWindowStoreTest.windowedPair("a", "0003", 1L), TimeOrderedWindowStoreTest.windowedPair("a", "0001", 0L)), StreamsTestUtils.toListAndCloseIterator(this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("a"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(Long.MAX_VALUE))));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldReturnSameResultsForSingleKeyFetchAndEqualKeyRangeFetch(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0003"), 2L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aaa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 3L);
        try (WindowStoreIterator singleKeyIterator = this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("aa"), 0L, 5L);
             KeyValueIterator keyRangeIterator = this.cachingStore.fetch(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesKey("aa"), 0L, 5L);){
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertFalse((boolean)singleKeyIterator.hasNext());
            Assertions.assertFalse((boolean)keyRangeIterator.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldReturnSameResultsForSingleKeyFetchAndEqualKeyRangeBackwardFetch(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), TimeOrderedWindowStoreTest.bytesValue("0001"), 0L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0002"), 1L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aa"), TimeOrderedWindowStoreTest.bytesValue("0003"), 2L);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("aaa"), TimeOrderedWindowStoreTest.bytesValue("0004"), 3L);
        try (WindowStoreIterator singleKeyIterator = this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(5L));
             KeyValueIterator keyRangeIterator = this.cachingStore.backwardFetch((Object)TimeOrderedWindowStoreTest.bytesKey("aa"), (Object)TimeOrderedWindowStoreTest.bytesKey("aa"), Instant.ofEpochMilli(0L), Instant.ofEpochMilli(5L));){
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertEquals((Object)this.stringFrom((byte[])((KeyValue)singleKeyIterator.next()).value), (Object)this.stringFrom((byte[])((KeyValue)keyRangeIterator.next()).value));
            Assertions.assertFalse((boolean)singleKeyIterator.hasNext());
            Assertions.assertFalse((boolean)keyRangeIterator.hasNext());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowNullPointerExceptionOnPutNullKey(boolean hasIndex) {
        this.setUp(hasIndex);
        Assertions.assertThrows(NullPointerException.class, () -> this.cachingStore.put(null, TimeOrderedWindowStoreTest.bytesValue("anyValue"), 0L));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldNotThrowNullPointerExceptionOnPutNullValue(boolean hasIndex) {
        this.setUp(hasIndex);
        this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey("a"), null, 0L);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldThrowNullPointerExceptionOnFetchNullKey(boolean hasIndex) {
        this.setUp(hasIndex);
        Assertions.assertThrows(NullPointerException.class, () -> this.cachingStore.fetch(null, Instant.ofEpochMilli(1L), Instant.ofEpochMilli(2L)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes keyFrom = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(-1)));
        Bytes keyTo = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(1)));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(TimeOrderedCachingWindowStore.class);
             KeyValueIterator iterator = this.cachingStore.fetch(keyFrom, keyTo, 0L, 10L);){
            Assertions.assertFalse((boolean)iterator.hasNext());
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldNotThrowInvalidBackwardRangeExceptionWithNegativeFromKey(boolean hasIndex) {
        this.setUp(hasIndex);
        Bytes keyFrom = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(-1)));
        Bytes keyTo = Bytes.wrap((byte[])new IntegerSerializer().serialize("", Integer.valueOf(1)));
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(TimeOrderedCachingWindowStore.class);
             KeyValueIterator iterator = this.cachingStore.backwardFetch((Object)keyFrom, (Object)keyTo, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(10L));){
            Assertions.assertFalse((boolean)iterator.hasNext());
            List messages = appender.getMessages();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldCloseCacheAndWrappedStoreAfterErrorDuringCacheFlush(boolean hasIndex) {
        this.setUp(hasIndex);
        this.setUpCloseTests();
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on flush")}).when((Object)this.cache)).flush(CACHE_NAMESPACE);
        Assertions.assertThrows(RuntimeException.class, () -> ((TimeOrderedCachingWindowStore)this.cachingStore).close());
        this.verifyAndTearDownCloseTests();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldCloseWrappedStoreAfterErrorDuringCacheClose(boolean hasIndex) {
        this.setUp(hasIndex);
        this.setUpCloseTests();
        ((ThreadCache)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).when((Object)this.cache)).close(CACHE_NAMESPACE);
        Assertions.assertThrows(RuntimeException.class, () -> ((TimeOrderedCachingWindowStore)this.cachingStore).close());
        this.verifyAndTearDownCloseTests();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldCloseCacheAfterErrorDuringStateStoreClose(boolean hasIndex) {
        this.setUp(hasIndex);
        this.setUpCloseTests();
        ((RocksDBTimeOrderedWindowStore)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Simulating an error on close")}).when((Object)this.underlyingStore)).close();
        Assertions.assertThrows(RuntimeException.class, () -> ((TimeOrderedCachingWindowStore)this.cachingStore).close());
        this.verifyAndTearDownCloseTests();
    }

    private void setUpCloseTests() {
        this.underlyingStore = (RocksDBTimeOrderedWindowStore)Mockito.mock(RocksDBTimeOrderedWindowStore.class);
        Mockito.when((Object)this.underlyingStore.name()).thenReturn((Object)"store-name");
        Mockito.when((Object)this.underlyingStore.isOpen()).thenReturn((Object)true);
        this.cachingStore = new TimeOrderedCachingWindowStore((WindowStore)this.underlyingStore, WINDOW_SIZE.longValue(), 100L);
        this.cache = (ThreadCache)Mockito.mock(ThreadCache.class);
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), null, null, null, this.cache);
        this.context.setRecordContext(new ProcessorRecordContext(10L, 0L, 0, TOPIC, (Headers)new RecordHeaders()));
        this.cachingStore.init(this.context, (StateStore)this.cachingStore);
    }

    private static KeyValue<Windowed<Bytes>, byte[]> windowedPair(String key, String value, long timestamp) {
        return KeyValue.pair((Object)new Windowed((Object)TimeOrderedWindowStoreTest.bytesKey(key), (Window)new TimeWindow(timestamp, timestamp + WINDOW_SIZE)), (Object)TimeOrderedWindowStoreTest.bytesValue(value));
    }

    private int addItemsToCache() {
        String kv;
        int i = 0;
        for (long cachedSize = 0L; cachedSize < 300L; cachedSize += ThreadCacheTest.memoryCacheEntrySize(kv.getBytes(), kv.getBytes(), TOPIC) + 8L + 4L) {
            kv = String.valueOf(i++);
            this.cachingStore.put(TimeOrderedWindowStoreTest.bytesKey(kv), TimeOrderedWindowStoreTest.bytesValue(kv), 10L);
        }
        return i;
    }

    private void verifyAndTearDownCloseTests() {
        ((RocksDBTimeOrderedWindowStore)Mockito.verify((Object)this.underlyingStore)).close();
        ((ThreadCache)Mockito.verify((Object)this.cache)).flush(CACHE_NAMESPACE);
        ((ThreadCache)Mockito.verify((Object)this.cache)).close(CACHE_NAMESPACE);
        Mockito.reset((Object[])new ThreadCache[]{this.cache});
        Mockito.reset((Object[])new RocksDBTimeOrderedWindowStore[]{this.underlyingStore});
    }
}

