/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.internals.TimestampedSegment;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class TimestampedSegmentTest {
    private final RocksDBMetricsRecorder metricsRecorder = new RocksDBMetricsRecorder("metrics-scope", "store-name");

    @BeforeEach
    public void setUp() {
        this.metricsRecorder.init(new StreamsMetricsImpl(new Metrics(), "test-client", "processId", (Time)new MockTime()), new TaskId(0, 0));
    }

    @Test
    public void shouldDeleteStateDirectoryOnDestroy() throws Exception {
        TimestampedSegment segment = new TimestampedSegment("segment", "window", 0L, Position.emptyPosition(), this.metricsRecorder);
        String directoryPath = TestUtils.tempDirectory().getAbsolutePath();
        File directory = new File(directoryPath);
        segment.openDB(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"metrics.recording.level", (Object)"INFO")}), directory);
        Assertions.assertTrue((boolean)new File(directoryPath, "window").exists());
        Assertions.assertTrue((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assertions.assertTrue((new File(directoryPath + File.separator + "window", "segment").list().length > 0 ? 1 : 0) != 0);
        segment.destroy();
        Assertions.assertFalse((boolean)new File(directoryPath + File.separator + "window", "segment").exists());
        Assertions.assertTrue((boolean)new File(directoryPath, "window").exists());
        segment.close();
    }

    @Test
    public void shouldBeEqualIfIdIsEqual() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, Position.emptyPosition(), this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segment));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.equalTo((Object)segmentSameId));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)segmentDifferentId)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo(null)));
        MatcherAssert.assertThat((Object)segment, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"anyName")));
        segment.close();
        segmentSameId.close();
        segmentDifferentId.close();
    }

    @Test
    public void shouldHashOnSegmentIdOnly() {
        TimestampedSegment segment = new TimestampedSegment("anyName", "anyName", 0L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segmentSameId = new TimestampedSegment("someOtherName", "someOtherName", 0L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segmentDifferentId = new TimestampedSegment("anyName", "anyName", 1L, Position.emptyPosition(), this.metricsRecorder);
        HashSet<TimestampedSegment> set = new HashSet<TimestampedSegment>();
        Assertions.assertTrue((boolean)set.add(segment));
        Assertions.assertFalse((boolean)set.add(segmentSameId));
        Assertions.assertTrue((boolean)set.add(segmentDifferentId));
        segment.close();
        segmentSameId.close();
        segmentDifferentId.close();
    }

    @Test
    public void shouldCompareSegmentIdOnly() {
        TimestampedSegment segment1 = new TimestampedSegment("a", "C", 50L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segment2 = new TimestampedSegment("b", "B", 100L, Position.emptyPosition(), this.metricsRecorder);
        TimestampedSegment segment3 = new TimestampedSegment("c", "A", 0L, Position.emptyPosition(), this.metricsRecorder);
        MatcherAssert.assertThat((Object)segment1.compareTo(segment1), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment1.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment1), (Matcher)Matchers.equalTo((Object)-1));
        MatcherAssert.assertThat((Object)segment2.compareTo(segment3), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)segment3.compareTo(segment2), (Matcher)Matchers.equalTo((Object)-1));
        segment1.close();
        segment2.close();
        segment3.close();
    }
}

