/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreBuilder;
import org.apache.kafka.streams.state.internals.CachingWindowStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedWindowBytesStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimeOrderedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.TimeOrderedCachingWindowStore;
import org.apache.kafka.streams.state.internals.TimestampedWindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WindowToTimestampedWindowByteStoreAdapter;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class TimestampedWindowStoreBuilderTest {
    private static final String TIMESTAMP_STORE_NAME = "Timestamped Store";
    private static final String TIMEORDERED_STORE_NAME = "TimeOrdered Store";
    private static final String STORE_NAME = "name";
    private static final String METRICS_SCOPE = "metricsScope";
    @Mock
    private WindowBytesStoreSupplier supplier;
    @Mock
    private RocksDBTimestampedWindowStore timestampedStore;
    @Mock
    private RocksDBTimeOrderedWindowStore timeOrderedStore;
    private TimestampedWindowStoreBuilder<String, String> builder;
    private boolean isTimeOrderedStore;
    private WindowStore inner;

    public void setUpWithoutInner(String storeName) {
        this.isTimeOrderedStore = TIMEORDERED_STORE_NAME.equals(storeName);
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)METRICS_SCOPE);
        this.builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    public void setUp(String storeName) {
        this.isTimeOrderedStore = TIMEORDERED_STORE_NAME.equals(storeName);
        this.inner = this.isTimeOrderedStore ? this.timeOrderedStore : this.timestampedStore;
        Mockito.when((Object)((WindowStore)this.supplier.get())).thenReturn((Object)this.inner);
        this.setUpWithoutInner(storeName);
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldHaveMeteredStoreAsOuterStore(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldHaveChangeLoggingStoreByDefault(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = this.builder.build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldNotHaveChangeLoggingStoreWhenDisabled(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldHaveCachingStoreWhenEnabled(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        if (this.isTimeOrderedStore) {
            MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(TimeOrderedCachingWindowStore.class));
        } else {
            MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        }
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled(String storeName) {
        this.setUp(storeName);
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedWindowStore.class));
        if (this.isTimeOrderedStore) {
            MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(TimeOrderedCachingWindowStore.class));
        } else {
            MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingWindowStore.class));
        }
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedWindowBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldNotWrapTimestampedByteStore(String storeName) {
        this.setUp(storeName);
        Mockito.when((Object)((WindowStore)this.supplier.get())).thenReturn((Object)new RocksDBTimestampedWindowStore((SegmentedBytesStore)new RocksDBTimestampedSegmentedBytesStore(STORE_NAME, "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedWindowStore.class));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldWrapPlainKeyValueStoreAsTimestampStore(String storeName) {
        this.setUp(storeName);
        Mockito.when((Object)((WindowStore)this.supplier.get())).thenReturn((Object)new RocksDBWindowStore((SegmentedBytesStore)new RocksDBSegmentedBytesStore(STORE_NAME, "metric-scope", 10L, 5L, (SegmentedBytesStore.KeySchema)new WindowKeySchema()), false, 1L));
        TimestampedWindowStore store = (TimestampedWindowStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(WindowToTimestampedWindowByteStoreAdapter.class));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldDisableCachingWithRetainDuplicates(String storeName) {
        this.setUpWithoutInner(storeName);
        this.supplier = Stores.persistentTimestampedWindowStore((String)STORE_NAME, (Duration)Duration.ofMillis(10L), (Duration)Duration.ofMillis(10L), (boolean)true);
        StoreBuilder builder = new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()).withCachingEnabled();
        builder.build();
        Assertions.assertFalse((boolean)((AbstractStoreBuilder)builder).enableCaching);
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldThrowNullPointerIfInnerIsNull(String storeName) {
        this.setUpWithoutInner(storeName);
        Assertions.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldThrowNullPointerIfTimeIsNull(String storeName) {
        this.setUpWithoutInner(storeName);
        Assertions.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @ValueSource(strings={"Timestamped Store", "TimeOrdered Store"})
    @ParameterizedTest
    public void shouldThrowNullPointerIfMetricsScopeIsNull(String storeName) {
        this.setUpWithoutInner(storeName);
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new TimestampedWindowStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"storeSupplier's metricsScope can't be null");
    }
}

