/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.VersionedBytesStoreSupplier;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingVersionedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.MeteredVersionedKeyValueStore;
import org.apache.kafka.streams.state.internals.VersionedKeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class VersionedKeyValueStoreBuilderTest {
    private static final String STORE_NAME = "versioned-store";
    private static final String METRICS_SCOPE = "metrics-scope";
    @Mock
    private VersionedBytesStoreSupplier supplier;
    @Mock
    private VersionedBytesStore inner;
    private VersionedKeyValueStoreBuilder<String, String> builder;

    private void setUpWithoutInner() {
        Mockito.when((Object)this.supplier.name()).thenReturn((Object)STORE_NAME);
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn((Object)METRICS_SCOPE);
        this.builder = new VersionedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    private void setUp() {
        Mockito.when((Object)((KeyValueStore)this.supplier.get())).thenReturn((Object)this.inner);
        this.setUpWithoutInner();
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        this.setUp();
        VersionedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        this.setUp();
        VersionedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingVersionedKeyValueBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        this.setUp();
        VersionedKeyValueStore store = (VersionedKeyValueStore)this.builder.withLoggingDisabled().build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)Matchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        this.setUp();
        VersionedKeyValueStore store = (VersionedKeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredVersionedKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingVersionedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)next).wrapped(), (Matcher)Matchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldThrowWhenCachingEnabled() {
        this.setUpWithoutInner();
        Assertions.assertThrows(IllegalStateException.class, () -> this.builder.withCachingEnabled());
    }

    @Test
    public void shouldThrowNullPointerIfInnerIsNull() {
        this.setUpWithoutInner();
        Assertions.assertThrows(NullPointerException.class, () -> new VersionedKeyValueStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldNotThrowNullPointerIfKeySerdeIsNull() {
        this.setUpWithoutInner();
        new VersionedKeyValueStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldNotThrowNullPointerIfValueSerdeIsNull() {
        this.setUpWithoutInner();
        new VersionedKeyValueStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test
    public void shouldThrowNullPointerIfTimeIsNull() {
        this.setUpWithoutInner();
        Assertions.assertThrows(NullPointerException.class, () -> new VersionedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null));
    }

    @Test
    public void shouldThrowNullPointerIfNameIsNull() {
        this.setUpWithoutInner();
        Mockito.when((Object)this.supplier.name()).thenReturn(null);
        Assertions.assertThrows(NullPointerException.class, () -> new VersionedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }

    @Test
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        this.setUpWithoutInner();
        Mockito.when((Object)this.supplier.metricsScope()).thenReturn(null);
        Assertions.assertThrows(NullPointerException.class, () -> new VersionedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime()));
    }
}

