/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.tests;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.errors.TaskAssignmentException;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.StreamsPartitionAssignor;
import org.apache.kafka.streams.processor.internals.TaskManager;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentInfo;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.LegacySubscriptionInfoSerde;
import org.apache.kafka.streams.processor.internals.assignment.SubscriptionInfo;
import org.apache.kafka.streams.tests.SmokeTestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsUpgradeTest {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("StreamsUpgradeTest requires one argument (properties-file) but no provided: ");
        }
        String propFileName = args.length > 0 ? args[0] : null;
        Properties streamsProperties = Utils.loadProps((String)propFileName);
        System.out.println("StreamsTest instance started (StreamsUpgradeTest trunk)");
        System.out.println("props=" + String.valueOf(streamsProperties));
        KafkaStreams streams = StreamsUpgradeTest.buildStreams(streamsProperties);
        streams.start();
        Exit.addShutdownHook((String)"streams-shutdown-hook", () -> {
            System.out.println("closing Kafka Streams instance");
            System.out.flush();
            streams.close();
            System.out.println("UPGRADE-TEST-CLIENT-CLOSED");
            System.out.flush();
        });
    }

    public static KafkaStreams buildStreams(Properties streamsProperties) {
        StreamsBuilder builder = new StreamsBuilder();
        KTable dataTable = builder.table("data", Consumed.with(SmokeTestUtil.stringSerde, SmokeTestUtil.intSerde));
        KStream dataStream = dataTable.toStream();
        dataStream.process(SmokeTestUtil.printProcessorSupplier("data"), new String[0]);
        dataStream.to("echo");
        boolean runFkJoin = Boolean.parseBoolean(streamsProperties.getProperty("test.run_fk_join", "false"));
        if (runFkJoin) {
            try {
                KTable fkTable = builder.table("fk", Consumed.with(SmokeTestUtil.intSerde, SmokeTestUtil.stringSerde));
                StreamsUpgradeTest.buildFKTable((KStream<String, Integer>)dataStream, (KTable<Integer, String>)fkTable);
            }
            catch (Exception e) {
                System.err.println("Caught " + e.getMessage());
            }
        }
        Properties config = new Properties();
        config.setProperty("application.id", "StreamsUpgradeTest");
        config.put("commit.interval.ms", (Object)1000L);
        config.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        config.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        FutureKafkaClientSupplier kafkaClientSupplier = streamsProperties.containsKey("test.future.metadata") ? new FutureKafkaClientSupplier() : new DefaultKafkaClientSupplier();
        config.putAll((Map<?, ?>)streamsProperties);
        return new KafkaStreams(builder.build(), config, (KafkaClientSupplier)kafkaClientSupplier);
    }

    private static void buildFKTable(KStream<String, Integer> primaryTable, KTable<Integer, String> otherTable) {
        KStream kStream = primaryTable.toTable().join(otherTable, v -> v, (k0, v0) -> v0).toStream();
        kStream.process(SmokeTestUtil.printProcessorSupplier("fk"), new String[0]);
        kStream.to("fk-result", Produced.with(SmokeTestUtil.stringSerde, SmokeTestUtil.stringSerde));
    }

    private static class FutureKafkaClientSupplier
    extends DefaultKafkaClientSupplier {
        private FutureKafkaClientSupplier() {
        }

        public Consumer<byte[], byte[]> getConsumer(Map<String, Object> config) {
            config.put("partition.assignment.strategy", FutureStreamsPartitionAssignor.class.getName());
            return new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        }
    }

    private static class FutureAssignmentInfo
    extends AssignmentInfo {
        private final boolean bumpUsedVersion;
        private final boolean bumpSupportedVersion;
        final ByteBuffer originalUserMetadata;

        private FutureAssignmentInfo(boolean bumpUsedVersion, boolean bumpSupportedVersion, ByteBuffer bytes) {
            super(11, 11);
            this.bumpUsedVersion = bumpUsedVersion;
            this.bumpSupportedVersion = bumpSupportedVersion;
            this.originalUserMetadata = bytes;
        }

        public ByteBuffer encode() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.originalUserMetadata.rewind();
            DataOutputStream out = new DataOutputStream(baos);
            try {
                if (this.bumpUsedVersion) {
                    this.originalUserMetadata.getInt();
                    out.writeInt(12);
                } else {
                    out.writeInt(this.originalUserMetadata.getInt());
                }
                if (this.bumpSupportedVersion) {
                    this.originalUserMetadata.getInt();
                    out.writeInt(12);
                }
                try {
                    while (true) {
                        out.write(this.originalUserMetadata.get());
                    }
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    out.flush();
                    out.close();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
                    out.close();
                    return byteBuffer;
                }
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new TaskAssignmentException("Failed to encode AssignmentInfo", (Throwable)ex);
                }
            }
        }
    }

    private static class FutureSubscriptionInfo {
        private final int version;
        private final UUID processId;
        private final Set<TaskId> activeTasks;
        private final Set<TaskId> standbyTasks;
        private final String userEndPoint;

        FutureSubscriptionInfo(int version, UUID processId, Set<TaskId> activeTasks, Set<TaskId> standbyTasks, String userEndPoint) {
            this.version = version;
            this.processId = processId;
            this.activeTasks = activeTasks;
            this.standbyTasks = standbyTasks;
            this.userEndPoint = userEndPoint;
            if (version <= 11) {
                throw new IllegalArgumentException("this class can't be used with version " + version);
            }
        }

        private ByteBuffer encode() {
            byte[] endPointBytes = LegacySubscriptionInfoSerde.prepareUserEndPoint(this.userEndPoint);
            ByteBuffer buf = ByteBuffer.allocate(28 + this.activeTasks.size() * 8 + 4 + this.standbyTasks.size() * 8 + 4 + endPointBytes.length + 4 + 4);
            buf.putInt(this.version);
            buf.putInt(this.version);
            LegacySubscriptionInfoSerde.encodeClientUUID(buf, this.processId);
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.activeTasks, this.version);
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.standbyTasks, this.version);
            LegacySubscriptionInfoSerde.encodeUserEndPoint(buf, endPointBytes);
            buf.rewind();
            return buf;
        }
    }

    public static class FutureStreamsPartitionAssignor
    extends StreamsPartitionAssignor {
        private static final Map<String, String> CLIENT_TAGS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"t1", (Object)"v1"), Utils.mkEntry((Object)"t2", (Object)"v2")});
        private static final Logger log = LoggerFactory.getLogger(FutureStreamsPartitionAssignor.class);
        private AtomicInteger usedSubscriptionMetadataVersionPeek;
        private AtomicLong nextScheduledRebalanceMs;

        public FutureStreamsPartitionAssignor() {
            this.usedSubscriptionMetadataVersion = 12;
        }

        public void configure(Map<String, ?> configs) {
            Object o = configs.get("test.future.metadata");
            this.usedSubscriptionMetadataVersionPeek = o instanceof AtomicInteger ? (AtomicInteger)o : new AtomicInteger();
            configs.remove("test.future.metadata");
            this.nextScheduledRebalanceMs = new AssignorConfiguration(configs).referenceContainer().nextScheduledRebalanceMs;
            super.configure(configs);
        }

        public ByteBuffer subscriptionUserData(Set<String> topics) {
            TaskManager taskManager = this.taskManager();
            this.handleRebalanceStart(topics);
            byte uniqueField = 0;
            if (this.usedSubscriptionMetadataVersion <= 11) {
                uniqueField = (byte)(uniqueField + 1);
                return new SubscriptionInfo(this.usedSubscriptionMetadataVersion, 12, taskManager.processId(), this.userEndPoint(), taskManager.taskOffsetSums(), uniqueField, 0, CLIENT_TAGS).encode();
            }
            return new FutureSubscriptionInfo(this.usedSubscriptionMetadataVersion, taskManager.processId().id(), SubscriptionInfo.getActiveTasksFromTaskOffsetSumMap((Map)taskManager.taskOffsetSums()), SubscriptionInfo.getStandbyTasksFromTaskOffsetSumMap((Map)taskManager.taskOffsetSums()), this.userEndPoint()).encode();
        }

        public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
            try {
                super.onAssignment(assignment, metadata);
                this.usedSubscriptionMetadataVersionPeek.set(this.usedSubscriptionMetadataVersion);
                return;
            }
            catch (TaskAssignmentException taskAssignmentException) {
                int usedVersion;
                ByteBuffer data = assignment.userData();
                data.rewind();
                try (DataInputStream in = new DataInputStream((InputStream)new ByteBufferInputStream(data));){
                    usedVersion = in.readInt();
                }
                catch (IOException ex) {
                    throw new TaskAssignmentException("Failed to decode AssignmentInfo", (Throwable)ex);
                }
                if (usedVersion > 12) {
                    throw new IllegalStateException("Unknown metadata version: " + usedVersion + "; latest supported version: 111");
                }
                AssignmentInfo info = AssignmentInfo.decode((ByteBuffer)assignment.userData().putInt(0, 11));
                if (this.maybeUpdateSubscriptionVersion(usedVersion, info.commonlySupportedVersion())) {
                    log.info("Requested to schedule immediate rebalance due to version probing.");
                    this.nextScheduledRebalanceMs.set(0L);
                    this.usedSubscriptionMetadataVersionPeek.set(this.usedSubscriptionMetadataVersion);
                }
                ArrayList partitions = new ArrayList(assignment.partitions());
                partitions.sort(PARTITION_COMPARATOR);
                Map activeTasks = FutureStreamsPartitionAssignor.getActiveTasks(partitions, (AssignmentInfo)info);
                TaskManager taskManager = this.taskManager();
                taskManager.handleAssignment(activeTasks, info.standbyTasks());
                this.usedSubscriptionMetadataVersionPeek.set(this.usedSubscriptionMetadataVersion);
                return;
            }
        }

        public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
            boolean bumpSupportedVersion;
            Map subscriptions = groupSubscription.groupSubscription();
            HashSet<Integer> supportedVersions = new HashSet<Integer>();
            for (Map.Entry entry : subscriptions.entrySet()) {
                ConsumerPartitionAssignor.Subscription subscription = (ConsumerPartitionAssignor.Subscription)entry.getValue();
                SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)subscription.userData());
                supportedVersions.add(info.latestSupportedVersion());
            }
            Map assignment = null;
            HashMap<String, ConsumerPartitionAssignor.Subscription> downgradedSubscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
            for (ConsumerPartitionAssignor.Subscription subscription : subscriptions.values()) {
                SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)subscription.userData());
                if (info.version() >= 12) continue;
                assignment = super.assign(metadata, new ConsumerPartitionAssignor.GroupSubscription(subscriptions)).groupAssignment();
                break;
            }
            boolean bumpUsedVersion = false;
            if (assignment != null) {
                bumpSupportedVersion = supportedVersions.size() == 1 && (Integer)supportedVersions.iterator().next() == 12;
            } else {
                for (Map.Entry entry : subscriptions.entrySet()) {
                    ConsumerPartitionAssignor.Subscription subscription = (ConsumerPartitionAssignor.Subscription)entry.getValue();
                    SubscriptionInfo info = SubscriptionInfo.decode((ByteBuffer)subscription.userData().putInt(0, 11).putInt(4, 11));
                    downgradedSubscriptions.put((String)entry.getKey(), new ConsumerPartitionAssignor.Subscription(subscription.topics(), new SubscriptionInfo(11, 11, info.processId(), info.userEndPoint(), this.taskManager().taskOffsetSums(), 0, 0, CLIENT_TAGS).encode(), subscription.ownedPartitions()));
                }
                assignment = super.assign(metadata, new ConsumerPartitionAssignor.GroupSubscription(downgradedSubscriptions)).groupAssignment();
                bumpUsedVersion = true;
                bumpSupportedVersion = true;
            }
            HashMap<String, ConsumerPartitionAssignor.Assignment> newAssignment = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
            for (Map.Entry entry : assignment.entrySet()) {
                ConsumerPartitionAssignor.Assignment singleAssignment = (ConsumerPartitionAssignor.Assignment)entry.getValue();
                newAssignment.put((String)entry.getKey(), new ConsumerPartitionAssignor.Assignment(singleAssignment.partitions(), new FutureAssignmentInfo(bumpUsedVersion, bumpSupportedVersion, singleAssignment.userData()).encode()));
            }
            return new ConsumerPartitionAssignor.GroupAssignment(newAssignment);
        }
    }
}

