/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.utils;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessorWrapper;
import org.apache.kafka.streams.processor.api.WrappedFixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.WrappedProcessorSupplier;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.StoreBuilder;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;

public class TestUtils {
    public static final String PROCESSOR_WRAPPER_COUNTER_CONFIG = "wrapped.counter";

    public static void waitForApplicationState(List<KafkaStreams> streamsList, KafkaStreams.State state, Duration timeout) throws InterruptedException {
        org.apache.kafka.test.TestUtils.retryOnExceptionWithTimeout((long)timeout.toMillis(), () -> {
            Map<KafkaStreams, KafkaStreams.State> streamsToStates = streamsList.stream().collect(Collectors.toMap(stream -> stream, KafkaStreams::state));
            Map<KafkaStreams, KafkaStreams.State> wrongStateMap = streamsToStates.entrySet().stream().filter(entry -> entry.getValue() != state).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String reason = String.format("Expected all streams instances in %s to be %s within %d ms, but the following were not: %s", streamsList, state, timeout.toMillis(), wrongStateMap);
            MatcherAssert.assertThat((String)reason, (boolean)wrongStateMap.isEmpty());
        });
    }

    public static String safeUniqueTestName(TestInfo testInfo) {
        String methodName = testInfo.getTestMethod().map(Method::getName).orElse("unknownMethodName");
        return TestUtils.safeUniqueTestName(methodName);
    }

    private static String safeUniqueTestName(String testName) {
        return TestUtils.sanitize(testName + Uuid.randomUuid().toString());
    }

    private static String sanitize(String str) {
        return str.replace('-', '_').replace(':', '_').replace('.', '_').replace('[', '_').replace(']', '_').replace(' ', '_').replace('=', '_');
    }

    public static Map<Object, Object> dummyStreamsConfigMap() {
        HashMap<Object, Object> baseConfigs = new HashMap<Object, Object>();
        baseConfigs.put("application.id", "dummy-app-id");
        baseConfigs.put("bootstrap.servers", "local");
        return baseConfigs;
    }

    public static StoreFactory mockStoreFactory(String name) {
        StoreFactory storeFactory = (StoreFactory)Mockito.mock(StoreFactory.class);
        Mockito.when((Object)storeFactory.storeName()).thenReturn((Object)name);
        return storeFactory;
    }

    private static class CountingDelegatingFixedKeyProcessorSupplier<KIn, VIn, VOut>
    implements WrappedFixedKeyProcessorSupplier<KIn, VIn, VOut> {
        private final RecordingProcessorWrapper.WrapperRecorder counter;
        private final String processorName;
        private final FixedKeyProcessorSupplier<KIn, VIn, VOut> delegate;

        public CountingDelegatingFixedKeyProcessorSupplier(RecordingProcessorWrapper.WrapperRecorder counter, String processorName, FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier) {
            this.counter = counter;
            this.processorName = processorName;
            this.delegate = processorSupplier;
            counter.wrapProcessorSupplier(processorName);
        }

        public Set<StoreBuilder<?>> stores() {
            Set stores = this.delegate.stores();
            if (stores != null) {
                for (StoreBuilder store : stores) {
                    this.counter.wrapStateStore(this.processorName, store.name());
                }
            }
            return stores;
        }

        public FixedKeyProcessor<KIn, VIn, VOut> get() {
            return this.delegate.get();
        }
    }

    private static class CountingDelegatingProcessorSupplier<KIn, VIn, KOut, VOut>
    implements WrappedProcessorSupplier<KIn, VIn, KOut, VOut> {
        private final RecordingProcessorWrapper.WrapperRecorder counter;
        private final String processorName;
        private final ProcessorSupplier<KIn, VIn, KOut, VOut> delegate;

        public CountingDelegatingProcessorSupplier(RecordingProcessorWrapper.WrapperRecorder counter, String processorName, ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier) {
            this.counter = counter;
            this.processorName = processorName;
            this.delegate = processorSupplier;
            counter.wrapProcessorSupplier(processorName);
        }

        public Set<StoreBuilder<?>> stores() {
            Set stores = this.delegate.stores();
            if (stores != null) {
                for (StoreBuilder store : stores) {
                    this.counter.wrapStateStore(this.processorName, store.name());
                }
            }
            return stores;
        }

        public Processor<KIn, VIn, KOut, VOut> get() {
            return this.delegate.get();
        }
    }

    public static class RecordingProcessorWrapper
    implements ProcessorWrapper {
        private WrapperRecorder recorder;

        public void configure(Map<String, ?> configs) {
            this.recorder = configs.containsKey(TestUtils.PROCESSOR_WRAPPER_COUNTER_CONFIG) ? (WrapperRecorder)configs.get(TestUtils.PROCESSOR_WRAPPER_COUNTER_CONFIG) : new WrapperRecorder();
        }

        public <KIn, VIn, KOut, VOut> WrappedProcessorSupplier<KIn, VIn, KOut, VOut> wrapProcessorSupplier(String processorName, ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier) {
            return new CountingDelegatingProcessorSupplier<KIn, VIn, KOut, VOut>(this.recorder, processorName, processorSupplier);
        }

        public <KIn, VIn, VOut> WrappedFixedKeyProcessorSupplier<KIn, VIn, VOut> wrapFixedKeyProcessorSupplier(String processorName, FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier) {
            return new CountingDelegatingFixedKeyProcessorSupplier<KIn, VIn, VOut>(this.recorder, processorName, processorSupplier);
        }

        public static class WrapperRecorder {
            private final Set<String> uniqueStores = new HashSet<String>();
            private final Set<String> processorStoresCounted = new HashSet<String>();
            private final Set<String> wrappedProcessorNames = Collections.synchronizedSet(new HashSet());

            public void wrapProcessorSupplier(String name) {
                this.wrappedProcessorNames.add(name);
            }

            public void wrapStateStore(String processorName, String storeName) {
                String processorStoreKey;
                if (!this.uniqueStores.contains(storeName)) {
                    this.uniqueStores.add(storeName);
                }
                if (!this.processorStoresCounted.contains(processorStoreKey = processorName + storeName)) {
                    this.processorStoresCounted.add(processorStoreKey);
                }
            }

            public int numWrappedProcessors() {
                return this.wrappedProcessorNames.size();
            }

            public int numUniqueStateStores() {
                return this.uniqueStores.size();
            }

            public int numConnectedStateStores() {
                return this.processorStoresCounted.size();
            }

            public Set<String> wrappedProcessorNames() {
                return this.wrappedProcessorNames;
            }
        }
    }
}

