/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class UniqueTopicSerdeScope {
    private final Map<String, Class<?>> topicTypeRegistry = new TreeMap();

    public <T> UniqueTopicSerdeDecorator<T> decorateSerde(Serde<T> delegate, Properties config, boolean isKey) {
        UniqueTopicSerdeDecorator<T> decorator = new UniqueTopicSerdeDecorator<T>(delegate);
        decorator.configure(config.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue)), isKey);
        return decorator;
    }

    public Set<String> registeredTopics() {
        return Collections.unmodifiableSet(this.topicTypeRegistry.keySet());
    }

    public class UniqueTopicSerdeDecorator<T>
    implements Serde<T> {
        private final AtomicBoolean isKey = new AtomicBoolean(false);
        private final Serde<T> delegate;

        public UniqueTopicSerdeDecorator(Serde<T> delegate) {
            this.delegate = delegate;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.delegate.configure(configs, isKey);
            this.isKey.set(isKey);
        }

        public void close() {
            this.delegate.close();
        }

        public Serializer<T> serializer() {
            return new UniqueTopicSerializerDecorator(this.isKey, this.delegate.serializer());
        }

        public Deserializer<T> deserializer() {
            return new UniqueTopicDeserializerDecorator(this.isKey, this.delegate.deserializer());
        }
    }

    public class UniqueTopicDeserializerDecorator<T>
    implements Deserializer<T> {
        private final AtomicBoolean isKey;
        private final Deserializer<T> delegate;

        public UniqueTopicDeserializerDecorator(AtomicBoolean isKey, Deserializer<T> delegate) {
            this.isKey = isKey;
            this.delegate = delegate;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.delegate.configure(configs, isKey);
            this.isKey.set(isKey);
        }

        public T deserialize(String topic, byte[] data) {
            return (T)this.delegate.deserialize(topic, data);
        }

        public T deserialize(String topic, Headers headers, byte[] data) {
            return (T)this.delegate.deserialize(topic, headers, data);
        }

        public void close() {
            this.delegate.close();
        }
    }

    public class UniqueTopicSerializerDecorator<T>
    implements Serializer<T> {
        private final AtomicBoolean isKey;
        private final Serializer<T> delegate;

        public UniqueTopicSerializerDecorator(AtomicBoolean isKey, Serializer<T> delegate) {
            this.isKey = isKey;
            this.delegate = delegate;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.delegate.configure(configs, isKey);
            this.isKey.set(isKey);
        }

        public byte[] serialize(String topic, T data) {
            this.verifyTopic(topic, data);
            return this.delegate.serialize(topic, data);
        }

        public byte[] serialize(String topic, Headers headers, T data) {
            this.verifyTopic(topic, data);
            return this.delegate.serialize(topic, headers, data);
        }

        private void verifyTopic(String topic, T data) {
            if (data != null) {
                String key = topic + (this.isKey.get() ? "--key" : "--value");
                if (UniqueTopicSerdeScope.this.topicTypeRegistry.containsKey(key)) {
                    MatcherAssert.assertThat((String)String.format("key[%s] data[%s][%s]", key, data, data.getClass()), UniqueTopicSerdeScope.this.topicTypeRegistry.get(key), (Matcher)Matchers.equalTo(data.getClass()));
                } else {
                    UniqueTopicSerdeScope.this.topicTypeRegistry.put(key, data.getClass());
                }
            }
        }

        public void close() {
            this.delegate.close();
        }
    }
}

