/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.api.FixedKeyProcessor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.test.MockApiFixedKeyProcessor;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.jupiter.api.Assertions;

public class MockApiFixedKeyProcessorSupplier<KIn, VIn, VOut>
implements FixedKeyProcessorSupplier<KIn, VIn, VOut> {
    private final long scheduleInterval;
    private final PunctuationType punctuationType;
    private final List<MockApiFixedKeyProcessor<KIn, VIn, VOut>> processors = new ArrayList<MockApiFixedKeyProcessor<KIn, VIn, VOut>>();

    public MockApiFixedKeyProcessorSupplier() {
        this(-1L);
    }

    public MockApiFixedKeyProcessorSupplier(long scheduleInterval) {
        this(scheduleInterval, PunctuationType.STREAM_TIME);
    }

    public MockApiFixedKeyProcessorSupplier(long scheduleInterval, PunctuationType punctuationType) {
        this.scheduleInterval = scheduleInterval;
        this.punctuationType = punctuationType;
    }

    public FixedKeyProcessor<KIn, VIn, VOut> get() {
        MockApiFixedKeyProcessor processor = new MockApiFixedKeyProcessor(this.punctuationType, this.scheduleInterval);
        if (!StreamsTestUtils.isCheckSupplierCall()) {
            this.processors.add(processor);
        }
        return processor;
    }

    public MockApiFixedKeyProcessor<KIn, VIn, VOut> theCapturedProcessor() {
        return this.capturedProcessors(1).get(0);
    }

    public int capturedProcessorsCount() {
        return this.processors.size();
    }

    public List<MockApiFixedKeyProcessor<KIn, VIn, VOut>> capturedProcessors(int expectedNumberOfProcessors) {
        Assertions.assertEquals((int)expectedNumberOfProcessors, (int)this.processors.size());
        return this.processors;
    }
}

