/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;

public class MockKeyValueStore
implements KeyValueStore<Object, Object> {
    private static final AtomicInteger GLOBAL_FLUSH_COUNTER = new AtomicInteger(0);
    private final AtomicInteger instanceLastFlushCount = new AtomicInteger(-1);
    private final String name;
    private final boolean persistent;
    public boolean initialized = false;
    public boolean flushed = false;
    public boolean closed = true;
    public final ArrayList<Integer> keys = new ArrayList();
    public final ArrayList<byte[]> values = new ArrayList();
    public final StateRestoreCallback stateRestoreCallback = new StateRestoreCallback(){
        private final Deserializer<Integer> deserializer = new IntegerDeserializer();

        public void restore(byte[] key, byte[] value) {
            MockKeyValueStore.this.keys.add((Integer)this.deserializer.deserialize("", key));
            MockKeyValueStore.this.values.add(value);
        }
    };

    public MockKeyValueStore(String name, boolean persistent) {
        this.name = name;
        this.persistent = persistent;
    }

    public String name() {
        return this.name;
    }

    public void init(StateStoreContext stateStoreContext, StateStore root) {
        stateStoreContext.register(root, this.stateRestoreCallback);
        this.initialized = true;
        this.closed = false;
    }

    public void flush() {
        this.instanceLastFlushCount.set(GLOBAL_FLUSH_COUNTER.getAndIncrement());
        this.flushed = true;
    }

    public int getLastFlushCount() {
        return this.instanceLastFlushCount.get();
    }

    public void close() {
        this.closed = true;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public Position getPosition() {
        throw new UnsupportedOperationException("Position handling not implemented");
    }

    public void put(Object key, Object value) {
    }

    public Object putIfAbsent(Object key, Object value) {
        return null;
    }

    public Object delete(Object key) {
        return null;
    }

    public void putAll(List<KeyValue<Object, Object>> entries) {
    }

    public Object get(Object key) {
        return null;
    }

    public KeyValueIterator<Object, Object> range(Object from, Object to) {
        return null;
    }

    public <PS extends Serializer<P>, P> KeyValueIterator<Object, Object> prefixScan(P prefix, PS prefixKeySerializer) {
        return null;
    }

    public KeyValueIterator<Object, Object> all() {
        return null;
    }

    public long approximateNumEntries() {
        return 0L;
    }
}

