/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Serializer;

public final class MockRestoreConsumer<K, V>
extends MockConsumer<byte[], byte[]> {
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private TopicPartition assignedPartition = null;
    private long seekOffset = -1L;
    private long endOffset = 0L;
    private long currentOffset = 0L;
    private final ArrayList<ConsumerRecord<byte[], byte[]>> recordBuffer = new ArrayList();

    public MockRestoreConsumer(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        super(AutoOffsetResetStrategy.EARLIEST.name());
        this.reset();
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void reset() {
        this.assignedPartition = null;
        this.seekOffset = -1L;
        this.endOffset = 0L;
        this.recordBuffer.clear();
    }

    public void bufferRecord(ConsumerRecord<K, V> record) {
        this.recordBuffer.add((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), 0, 0, (Object)this.keySerializer.serialize(record.topic(), record.headers(), record.key()), (Object)this.valueSerializer.serialize(record.topic(), record.headers(), record.value()), record.headers(), Optional.empty()));
        this.endOffset = record.offset();
        super.updateEndOffsets(Collections.singletonMap(this.assignedPartition, this.endOffset));
    }

    public synchronized void assign(Collection<TopicPartition> partitions) {
        int numPartitions = partitions.size();
        if (numPartitions > 1) {
            throw new IllegalArgumentException("RestoreConsumer: more than one partition specified");
        }
        if (numPartitions == 1) {
            if (this.assignedPartition != null) {
                throw new IllegalStateException("RestoreConsumer: partition already assigned");
            }
            this.assignedPartition = partitions.iterator().next();
            super.updateBeginningOffsets(Collections.singletonMap(this.assignedPartition, 0L));
        }
        super.assign(partitions);
    }

    public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
        for (ConsumerRecord<byte[], byte[]> record : this.recordBuffer) {
            super.addRecord(record);
        }
        this.recordBuffer.clear();
        ConsumerRecords records = super.poll(timeout);
        List partitionRecords = records.records(this.assignedPartition);
        for (ConsumerRecord record : partitionRecords) {
            this.currentOffset = record.offset();
        }
        return records;
    }

    public synchronized long position(TopicPartition partition) {
        if (!partition.equals((Object)this.assignedPartition)) {
            throw new IllegalStateException("RestoreConsumer: unassigned partition");
        }
        return this.currentOffset;
    }

    public synchronized void seek(TopicPartition partition, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("RestoreConsumer: offset should not be negative");
        }
        if (this.seekOffset >= 0L) {
            throw new IllegalStateException("RestoreConsumer: offset already sought");
        }
        this.seekOffset = offset;
        this.currentOffset = offset;
        super.seek(partition, offset);
    }

    public synchronized void seekToBeginning(Collection<TopicPartition> partitions) {
        if (partitions.size() != 1) {
            throw new IllegalStateException("RestoreConsumer: other than one partition specified");
        }
        for (TopicPartition partition : partitions) {
            if (partition.equals((Object)this.assignedPartition)) continue;
            throw new IllegalStateException("RestoreConsumer: seek-to-end not on the assigned partition");
        }
        this.currentOffset = 0L;
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        if (partitions.size() != 1) {
            throw new IllegalStateException("RestoreConsumer: other than one partition specified");
        }
        for (TopicPartition partition : partitions) {
            if (partition.equals((Object)this.assignedPartition)) continue;
            throw new IllegalStateException("RestoreConsumer: seek-to-end not on the assigned partition");
        }
        this.currentOffset = this.endOffset;
        return super.endOffsets(partitions);
    }
}

