/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreListener;

public class MockStateRestoreListener
implements StateRestoreListener {
    public final Map<String, String> storeNameCalledStates = new HashMap<String, String>();
    public long restoreStartOffset;
    public long restoreEndOffset;
    public long restoredBatchOffset;
    public long numBatchRestored;
    public long totalNumRestored;
    public TopicPartition restoreTopicPartition;
    public static final String RESTORE_START = "restore_start";
    public static final String RESTORE_BATCH = "restore_batch";
    public static final String RESTORE_END = "restore_end";
    public static final String RESTORE_SUSPENDED = "restore_suspended";

    public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_START, storeName);
        this.restoreStartOffset = startingOffset;
        this.restoreEndOffset = endingOffset;
    }

    public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_BATCH, storeName);
        this.restoredBatchOffset = batchEndOffset;
        this.numBatchRestored = numRestored;
    }

    public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_END, storeName);
        this.totalNumRestored = totalRestored;
    }

    public void onRestoreSuspended(TopicPartition topicPartition, String storeName, long totalRestored) {
        this.restoreTopicPartition = topicPartition;
        this.storeNameCalledStates.put(RESTORE_SUSPENDED, storeName);
        this.totalNumRestored = totalRestored;
    }

    public String toString() {
        return "MockStateRestoreListener{storeNameCalledStates=" + String.valueOf(this.storeNameCalledStates) + ", restoreStartOffset=" + this.restoreStartOffset + ", restoreEndOffset=" + this.restoreEndOffset + ", restoredBatchOffset=" + this.restoredBatchOffset + ", numBatchRestored=" + this.numBatchRestored + ", totalNumRestored=" + this.totalNumRestored + ", restoreTopicPartition=" + String.valueOf(this.restoreTopicPartition) + "}";
    }
}

