/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.File;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class NoOpReadOnlyStore<K, V>
implements ReadOnlyKeyValueStore<K, V>,
StateStore {
    private final String name;
    private final boolean rocksdbStore;
    private boolean open = true;
    public boolean initialized;
    public boolean flushed;

    public NoOpReadOnlyStore() {
        this("", false);
    }

    public NoOpReadOnlyStore(String name) {
        this(name, false);
    }

    public NoOpReadOnlyStore(String name, boolean rocksdbStore) {
        this.name = name;
        this.rocksdbStore = rocksdbStore;
    }

    public V get(K key) {
        return null;
    }

    public KeyValueIterator<K, V> range(K from, K to) {
        return null;
    }

    public <PS extends Serializer<P>, P> KeyValueIterator<K, V> prefixScan(P prefix, PS prefixKeySerializer) {
        return null;
    }

    public KeyValueIterator<K, V> all() {
        return null;
    }

    public long approximateNumEntries() {
        return 0L;
    }

    public String name() {
        return this.name;
    }

    public void init(StateStoreContext stateStoreContext, StateStore root) {
        if (this.rocksdbStore) {
            new File(String.valueOf(stateStoreContext.stateDir()) + File.separator + "rocksdb" + File.separator + this.name).mkdirs();
        } else {
            new File(String.valueOf(stateStoreContext.stateDir()) + File.separator + this.name).mkdir();
        }
        this.initialized = true;
        stateStoreContext.register(root, (k, v) -> {});
    }

    public void flush() {
        this.flushed = true;
    }

    public void close() {
        this.open = false;
    }

    public boolean persistent() {
        return this.rocksdbStore;
    }

    public boolean isOpen() {
        return this.open;
    }

    public Position getPosition() {
        throw new UnsupportedOperationException("Position handling not implemented");
    }
}

