<?php
function mbrni_reports_courses() { 

	global $wpdb;

	?>
	<h2>All Courses</h2>
<table class="widefat fixed" cellspacing="0">
    <thead>
    <tr>
        <th id="coursenname" class="manage-column column-coursename" scope="col">Course Name</th>
        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">No. Members</th>

    </tr>
    </thead>

    <tfoot>
    <tr>
        <th class="manage-column column-coursename" scope="col">Course Name</th>
        <th class="manage-column column-membermembers num" scope="col">No. Members</th>

    </tr>
    </tfoot>

    <tbody>


<?php

$courselist_args=array('post_type' => 'memberoni_course', 'post_status'=> 'publish','posts_per_page' => -1,'post_parent' => 0, 'orderby' => 'menu_order','order' => 'ASC','meta_key'=>'course_status','meta_value'=>'active');
$courselist=get_posts($courselist_args);


foreach ($courselist as $course) :

	echo '<tr><td class="column-coursename">' . $course->post_title . '</td>';

	if (get_field('course_page_type',$course->ID)=='standalone') :
		if (get_field('disable_tracking',$course->ID)) :
			echo '<td class="column-coursename num">0</td></tr>';
		else:
			$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker where lesson_id=$course->ID and lesson_status='3'");
			$number_of_users=$wpdb->num_rows;
			wp_reset_query();
			echo '<td class="column-coursename num"><a href="./admin.php?page=mbrni_reports&amp;course_id=' . $course->ID . '&amp;course_view_type=comp">' . $number_of_users . '</a></td><tr>';
		endif;
	else:
		if (get_field('disable_tracking',$course->ID)) :
			echo '<td class="column-coursename num">0</td></tr>';
		else:
			$children_args = array(
				'post_parent' => $course->ID,
				'post_type'   => 'memberoni_course', 
				'numberposts' => -1,
				'post_status' => 'publish', 
			); 

			$children_array = get_children( $children_args );
			$children_ids=array();
			foreach ($children_array as $child_course) :


				if (get_field('course_page_type',$child_course->ID) == 'module') :
					$module_children=get_pages(array('parent' => $child_course->ID,'post_type' => 'memberoni_course','post_status'=>'publish'));
					if ($module_children) :
						$module_children_list=null;
						foreach($module_children as $module_child) :
							//if (!get_field('disable_tracking',$module_child->ID) && get_field('lesson_status',$module_child->ID)!='inactive') :
							if (!get_field('disable_tracking',$module_child->ID)) :
								array_push($children_ids,$module_child->ID);
							endif;
						endforeach;
					endif;
				else:
					//if (!get_field('disable_tracking',$child_course->ID) && get_field('lesson_status',$child_course->ID)!='inactive') :
					if (!get_field('disable_tracking',$child_course->ID)) :
						array_push($children_ids,$child_course->ID);
					endif;
				endif;

			endforeach;
			$children_ids_list=join(',',$children_ids);

			if ($children_ids_list) :

				$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker WHERE lesson_id IN ($children_ids_list) AND lesson_status='3'");
				$number_of_users=$wpdb->num_rows;
				wp_reset_query();

			 echo '<td class="column-coursename num"><a href="./admin.php?page=mbrni_reports&amp;course_id=' . $course->ID . '&amp;course_view_type=comp">' . $number_of_users . '</a></td><tr>';

			else:

			 echo '<td class="column-coursename num">0</td></tr>';

			endif;
		endif;

	endif;


endforeach;


?>
    </tbody>
</table> 

<?php } 

function mbrni_reports_courses_detail($course_id,$view_type) { 
global $wpdb;

if ($view_type=='comp') :
	$course_db=$wpdb->prefix . "lessontracker";
elseif ($view_type=='views') :
	$course_db=$wpdb->prefix . "lessonlog";
endif;

	?>

<h2><a href="./admin.php?page=mbrni_reports">All Courses</a> &rarr; <?php echo get_the_title($course_id); ?></h2>

<table class="widefat fixed" cellspacing="0">
    <thead>
    <tr>
        <th id="coursenname" class="manage-column column-coursename" scope="col">Member Name</th>
        <?php if ($view_type=='comp') : ?>

        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">No. Lessons</th>
        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">%</th>
        <?php endif; ?>
    </tr>
    </thead>

    <tfoot>
    <tr>
        <th class="manage-column column-coursename" scope="col">Member Name</th>
        <?php if ($view_type=='comp') : ?>

        <th class="manage-column column-membermembers num" scope="col">No. Lessons</th>
        <th class="manage-column column-membermembers num" scope="col">%</th><?php endif; ?>

    </tr>
    </tfoot>

    <tbody>


<?php

	if (get_field('course_page_type',$course_id)=='standalone') :

		$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker where lesson_id=$course_id and lesson_status='3'");

		foreach ($count_query as $count_result) :

			$user_id=$count_result->user_id;
			$user_info=get_userdata($user_id);
			echo '<tr class="' . $row_class . '" style="color:green!important;font-weight:bold;">';
			echo '<td class="column-coursename">' . $user_info->first_name . ' ' . $user_info->last_name . ' (' . $user_info->user_login . ')</td>';
			echo '<td class="column-coursename num">1</td>';
			echo '<td class="column-coursename num">100%</td>';
			echo '</tr>';

			if ($row_class=='alternate') : $row_class='';
			else: $row_class='alternate';
			endif;

		endforeach;


	else:

		$children_args = array(
			'post_parent' => $course_id,
			'post_type'   => 'memberoni_course', 
			'numberposts' => -1,
			'post_status' => 'publish' 
		); 

		$children_array = get_children( $children_args );
		$children_ids=array();

		foreach ($children_array as $child_course) :

			if (get_field('course_page_type',$child_course->ID) == 'module') :
				$module_children=get_pages(array('parent' => $child_course->ID,'post_type' => 'memberoni_course','post_status'=>'publish'));
				if ($module_children) :
					$module_children_list=null;
					foreach($module_children as $module_child) :
						//if (!get_field('disable_tracking',$module_child->ID) && get_field('lesson_status',$module_child->ID)!='inactive') :
						if (!get_field('disable_tracking',$module_child->ID)) :
							array_push($children_ids,$module_child->ID);
						endif;
					endforeach;
				endif;
			else:
				//if (!get_field('disable_tracking',$child_course->ID) && get_field('lesson_status',$child_course->ID)!='inactive') :
				if (!get_field('disable_tracking',$child_course->ID)) :
					array_push($children_ids,$child_course->ID);
				endif;
			endif;

		endforeach;	

		$children_ids_list=join(',',$children_ids);


		if ($view_type=='comp') :
			$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker WHERE lesson_id IN ($children_ids_list) AND lesson_status='3'");
		endif;


		$number_of_users_views=$wpdb->num_rows;
		wp_reset_query();


		$row_class='';



		foreach ($count_query as $count_result) :

			$number_of_users=0;
			$user_id=$count_result->user_id;
			$user_info=get_userdata($user_id);
			if ($view_type=='comp') :
				$count_query_views = $wpdb->get_results("SELECT DISTINCT lesson_id FROM $course_db WHERE (user_id=$user_id AND lesson_id IN ($children_ids_list) AND lesson_status='3')");

				$number_of_users_views=$wpdb->num_rows;
				wp_reset_query();

				$percent_complete=round((($number_of_users_views/count($children_ids)) * 100),0);
			endif;

				if ($view_type=='comp' && $percent_complete==100) :
					echo '<tr class="' . $row_class . '" style="color:green!important;font-weight:bold;">';
				else:
					echo '<tr class="' . $row_class . '">';
				endif;

			echo '<td class="column-coursename">' . $user_info->first_name . ' ' . $user_info->last_name . ' (' . $user_info->user_login . ')</td>';
			if ($view_type=='comp') :

				echo '<td class="column-coursename num">' . $number_of_users_views . '</td>';
				echo '<td class="column-coursename num">' . $percent_complete . '%</td>';
			endif;
		 echo '</tr>';

		 if ($row_class=='alternate') : $row_class='';
		 else: $row_class='alternate';
		 endif;




		endforeach;
	endif;






?>
    </tbody>
</table> 

<?php }