<?php
function mbrni_reports_roadmaps() { 

	global $wpdb;

	?>
	<h2>All Roadmaps</h2>
<table class="widefat fixed" cellspacing="0">
    <thead>
    <tr>
        <th id="roadmapnname" class="manage-column column-roadmapname" scope="col">Roadmap Name</th>
        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">No. Members</th>

    </tr>
    </thead>

    <tfoot>
    <tr>
        <th class="manage-column column-roadmapname" scope="col">Roadmap Name</th>
        <th class="manage-column column-membermembers num" scope="col">No. Members</th>

    </tr>
    </tfoot>

    <tbody>


<?php

$roadmaplist_args=array('post_type' => 'memberoni_roadmap', 'post_status'=> 'publish','posts_per_page' => -1,'post_parent' => 0, 'orderby' => 'menu_order','order' => 'ASC','meta_key'=>'course_status','meta_value'=>'active');
$roadmaplist=get_posts($roadmaplist_args);


foreach ($roadmaplist as $roadmap) :

	echo '<tr><td class="column-roadmapname">' . $roadmap->post_title . '</td>';

		if (get_field('disable_tracking',$roadmap->ID)) :
			echo '<td class="column-roadmapname num">0</td></tr>';
		else:
			$children_args = array(
				'post_parent' => $roadmap->ID,
				'post_type'   => 'memberoni_roadmap', 
				'numberposts' => -1,
				'post_status' => 'publish', 
			); 

			$children_array = get_children( $children_args );
			$children_ids=array();
			foreach ($children_array as $child_roadmap) :

				//if (!get_field('disable_tracking',$child_roadmap->ID) && get_field('lesson_status',$child_roadmap->ID)!='inactive') :
				if (!get_field('disable_tracking',$child_roadmap->ID)) :
					array_push($children_ids,$child_roadmap->ID);
				endif;

			endforeach;
			$children_ids_list=join(',',$children_ids);

			if ($children_ids_list) :

				$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker WHERE lesson_id IN ($children_ids_list) AND lesson_status='3'");
				$number_of_users=$wpdb->num_rows;
				wp_reset_query();

			 echo '<td class="column-roadmapname num"><a href="./admin.php?page=mbrni_reports_roadmap&amp;roadmap_id=' . $roadmap->ID . '&amp;roadmap_view_type=comp">' . $number_of_users . '</a></td><tr>';

			else:

			 echo '<td class="column-roadmapname num">0</td></tr>';

			endif;
		endif;



endforeach;


?>
    </tbody>
</table> 

<?php } 

function mbrni_reports_roadmaps_detail($roadmap_id,$view_type) { 
global $wpdb;

if ($view_type=='comp') :
	$roadmap_db=$wpdb->prefix . "lessontracker";
elseif ($view_type=='views') :
	$roadmap_db=$wpdb->prefix . "lessonlog";
endif;

	?>

<h2><a href="./admin.php?page=mbrni_reports_roadmap">All Roadmaps</a> &rarr; <?php echo get_the_title($roadmap_id); ?></h2>

<table class="widefat fixed" cellspacing="0">
    <thead>
    <tr>
        <th id="roadmapnname" class="manage-column column-roadmapname" scope="col">Member Name</th>
        <?php if ($view_type=='comp') : ?>

        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">No. Lessons</th>
        <th id="numbermembers" class="manage-column column-membermembers num" scope="col">%</th>
        <?php endif; ?>
    </tr>
    </thead>

    <tfoot>
    <tr>
        <th class="manage-column column-roadmapname" scope="col">Member Name</th>
        <?php if ($view_type=='comp') : ?>

        <th class="manage-column column-membermembers num" scope="col">No. Lessons</th>
        <th class="manage-column column-membermembers num" scope="col">%</th><?php endif; ?>

    </tr>
    </tfoot>

    <tbody>


<?php


		$children_args = array(
			'post_parent' => $roadmap_id,
			'post_type'   => 'memberoni_roadmap', 
			'numberposts' => -1,
			'post_status' => 'publish' 
		); 

		$children_array = get_children( $children_args );
		$children_ids=array();

		foreach ($children_array as $child_roadmap) :

			//if (!get_field('disable_tracking',$child_roadmap->ID) && get_field('lesson_status',$child_roadmap->ID)!='inactive') :
			if (!get_field('disable_tracking',$child_roadmap->ID)) :
				array_push($children_ids,$child_roadmap->ID);
			endif;

		endforeach;	

		$children_ids_list=join(',',$children_ids);


		if ($view_type=='comp') :
			$count_query = $wpdb->get_results("SELECT DISTINCT user_id FROM ". $wpdb->prefix . "lessontracker WHERE lesson_id IN ($children_ids_list) AND lesson_status='3'");
		endif;


		$number_of_users_views=$wpdb->num_rows;
		wp_reset_query();


		$row_class='';



		foreach ($count_query as $count_result) :

			$number_of_users=0;
			$user_id=$count_result->user_id;
			$user_info=get_userdata($user_id);
			if ($view_type=='comp') :
				$count_query_views = $wpdb->get_results("SELECT DISTINCT lesson_id FROM $roadmap_db WHERE (user_id=$user_id AND lesson_id IN ($children_ids_list) AND lesson_status='3')");

				$number_of_users_views=$wpdb->num_rows;
				wp_reset_query();

				$percent_complete=round((($number_of_users_views/count($children_ids)) * 100),0);
			endif;

				if ($view_type=='comp' && $percent_complete==100) :
					echo '<tr class="' . $row_class . '" style="color:green!important;font-weight:bold;">';
				else:
					echo '<tr class="' . $row_class . '">';
				endif;

			echo '<td class="column-roadmapname">' . $user_info->first_name . ' ' . $user_info->last_name . ' (' . $user_info->user_login . ')</td>';
			if ($view_type=='comp') :

				echo '<td class="column-roadmapname num">' . $number_of_users_views . '</td>';
				echo '<td class="column-roadmapname num">' . $percent_complete . '%</td>';
			endif;
		 echo '</tr>';

		 if ($row_class=='alternate') : $row_class='';
		 else: $row_class='alternate';
		 endif;




		endforeach;






?>
    </tbody>
</table> 

<?php } 