<?php
/*
Plugin Name: Memberoni Course Reports
Description: Plugin to show basic course and roadmap usage reports for the Memberoni theme
Version: 2.0
Author: Mike Morrison
Author URI: http://www.membershipacademy.com
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

/*  Copyright 2016-2020  Mike Morrison (email : mike@membershipacademy.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

defined( 'ABSPATH' ) or die( 'Put the cookie down, now!' );

require_once (plugin_dir_path( __FILE__ ) . 'memberoni-reports-functions.php');
require_once (plugin_dir_path( __FILE__ ) . 'memberoni-reports-roadmap-functions.php');

add_action( 'admin_menu', 'mbrni_add_admin_menu' );


function mbrni_add_admin_menu(  ) { 

  add_menu_page( 'Memberoni Course Reports', 'Course Reports', 'manage_options', 'mbrni_reports', 'mbrni_options_page' );
  add_submenu_page( 'mbrni_reports','Course Reports', 'Course Reports', 'manage_options', 'mbrni_reports', 'mbrni_options_page' );
  add_submenu_page( 'mbrni_reports','Roadmap Reports', 'Roadmap Reports', 'manage_options', 'mbrni_reports_roadmap', 'mbrni_roadmap_page' );


}


function mbrni_options_page(  ) { 

  ?>
    <div class="wrap" style="overflow:hidden;">
      <h2>Memberoni Course Reports</h2>

      <?php 

      if (post_type_exists( 'memberoni_course' )) : 

        if (isset($_GET['course_id']) && isset($_GET['course_view_type'])) :

          if (
            is_numeric(sanitize_text_field($_GET['course_id'])) 
            && ((sanitize_text_field($_GET['course_view_type']) == 'comp') 
              || (sanitize_text_field($_GET['course_view_type']) == 'views')
              )
            ) :
            $course_id=sanitize_text_field($_GET['course_id']);
            $course_view_type=sanitize_text_field($_GET['course_view_type']);


            echo mbrni_reports_courses_detail($_GET['course_id'],$_GET['course_view_type']); 

          else: 
            
            echo mbrni_reports_courses(); 

          endif;

        else: 

        echo mbrni_reports_courses(); 

        endif;

      else:

        echo '<p><em>This plugin is for use with the <strong>Memberoni</strong> theme from <a href="https://www.membershipacademy.com">Membership Academy</a>, and is not compatible with your current theme</p>';
      endif;

      ?>

  </div>


  <?php

}

function mbrni_roadmap_page(  ) { 

  ?>
    <div class="wrap" style="overflow:hidden;">
      <h2>Memberoni Roadmap Reports</h2>

      <?php 

      if (post_type_exists( 'memberoni_roadmap' )) : 

        if (isset($_GET['roadmap_id']) && isset($_GET['roadmap_view_type'])) :

          if (
            is_numeric(sanitize_text_field($_GET['roadmap_id'])) 
            && ((sanitize_text_field($_GET['roadmap_view_type']) == 'comp') 
              || (sanitize_text_field($_GET['roadmap_view_type']) == 'views')
              )
            ) :
            $course_id=sanitize_text_field($_GET['roadmap_id']);
            $course_view_type=sanitize_text_field($_GET['roadmap_view_type']);


            echo mbrni_reports_roadmaps_detail($_GET['roadmap_id'],$_GET['roadmap_view_type']); 

          else: 
            
            echo mbrni_reports_roadmaps(); 

          endif;

        else: 

        echo mbrni_reports_roadmaps(); 

        endif;

      else:

        echo '<p><em>This plugin is for use with the <strong>Memberoni</strong> theme from <a href="https://www.membershipacademy.com">Membership Academy</a>, and is not compatible with your current theme</p>';
      endif;

      ?>

  </div>


  <?php

}
