/**
 * Qualpay frontend JS
 *
 * Load embedded field, tokenize card, and add card_id to form
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 */

jQuery(document).on('gform_post_render', gravityformsqualpay);

function gravityformsqualpay(event, form_id, current_page) {
    //console.log(GFP_QUALPAY_CURRENT_VERSION);
    //adding this portion because of gravityforms 2.9 version has changed their AJAX and JS submission methods.
    window.gform?.utils?.addFilter( 'gform/submission/pre_submission', ( data ) => {
        
        // Ignore next and previous page submissions
	    if ( data.submissionType !== gform.submission.SUBMISSION_TYPE_SUBMIT ) {
		    return data;
	    }

        //Do stuff to validate submission. If invalid, set data.abort = true to abort submission.    
        data.abort = true;
    
        jQuery('#gform_submit_button_'+ gfp_qualpay_frontend_strings.formId).click();

        // === Disable submit button after submission ===
        const submitButton = jQuery('#gform_submit_button_' + gfp_qualpay_frontend_strings.formId);
        submitButton.prop('disabled', true).val('Sending, please wait...');

        return data;

    });

    if (!window['gf_cc_rules']) {

        window['gf_cc_rules'] = gfp_qualpay_frontend_strings.credit_card_rules;

    }

    if (form_id !== parseInt(gfp_qualpay_frontend_strings.formId)) {

        return;

    }

    if (gfp_qualpay_frontend_strings.hasPages && current_page !== gfp_qualpay_frontend_strings.pageCount) {

        return;

    }

    if (gformQualpayIsPostback(form_id) && gformQualpayHasError(form_id)) {

        qpEmbeddedForm.unloadFrame();

        var post_data = {
            action: 'gaddon_qualpay_transient_key',
            gaddon_qualpay_transient_key: gfp_qualpay_frontend_strings.transient_key_nonce,
            form_id: form_id
        };

        jQuery.post(gfp_qualpay_frontend_strings.ajaxurl, post_data).done(function (response) {

            if (true === response.success) {

                gfp_qualpay_frontend_strings.transientKey = response.data;

                gravityformsqualpay_load_frame();

            }

        });

    }
    else {

        gravityformsqualpay_load_frame();

    }



}

/**
 * Load Qualpay embedded fields frame
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 */
function gravityformsqualpay_load_frame(){
   // var capture_id = jQuery("#capture_id").val();
    var achOnOff = jQuery("#achOnOff").val();
    
    var enable_ach = false;
    if(achOnOff == 1 || achOnOff == ''){
        enable_ach = true;
    }
    qpEmbeddedForm.loadFrame(gfp_qualpay_frontend_strings.merchant_id,
        {
            formId: gfp_qualpay_frontend_strings.form_element_id,
            mode: gfp_qualpay_frontend_strings.mode,
            transientKey: gfp_qualpay_frontend_strings.transientKey,
            tokenize: true,
            onSuccess: gravityformsqualpay_success,
            onError: gravityformsqualpay_error,
            achConfig: {
                enabled: enable_ach
               },
        });
}

/**
 * Success :-)
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 *
 * @param data
 */
function gravityformsqualpay_success(data) {
    var card_id = data.card_id,
        card_number = data.card_number,
        card_type = data.card_type,
        type_id = data.type_id,
        form_id = gfp_qualpay_frontend_strings.formId,
        form = jQuery('#gform_' + form_id),
        creditcard_field_id = gfp_qualpay_frontend_strings.creditcard_field_id;
	var first_five = card_number.slice(0, 5);
	var last_four = card_number.substr(card_number.length - 4);
    const types = {
            AM : 'Amex',
            DS : 'Discover',
            PP : 'PayPal',
            MC : 'MasterCard',
            VS : 'Visa', 
            AP : 'ACH'
    }
    
	form.find(gfp_qualpay_frontend_strings.responseField).val(card_id);
	
	form.find('#input_' + form_id + '_' + creditcard_field_id + '_1').val(last_four); 
	
	form.find('#input_' + form_id + '_' + creditcard_field_id + '_11').val(card_number);

    form.find('#input_' + form_id + '_' + creditcard_field_id + '_4').val(types[card_type]);
    
    form.find('#input_' + form_id + '_' + creditcard_field_id + '_5').val(type_id);

    form.submit();
}

/**
 * Error :-(
 *
 * @todo should we display error and not submit the form?
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 *
 * @param error
 */
function gravityformsqualpay_error(error) {

    var form = jQuery('#gform_' + gfp_qualpay_frontend_strings.formId);

    if (error.detail) {

        var error_detail = '';

        for (let key in error.detail) {

            error_detail += error.detail[key];

        }

        form.find(gfp_qualpay_frontend_strings.errorField).val(error_detail);

    }

    form.submit();

}

/**
 * Is this form a new page load or a postback
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 *
 * @param form_id
 * @returns {boolean}
 */
function gformQualpayIsPostback(form_id) {

    var is_postback = false;

    var ajax_contents = jQuery('#gform_ajax_frame_' + form_id).contents().find('*').html();

    if ('undefined' !== typeof(ajax_contents)) {

        is_postback = (0 < ajax_contents.indexOf('GF_AJAX_POSTBACK'));

    }


    return is_postback;
}

/**
 * Does this form have a validation error
 *
 * @since  1.0.0
 *
 * @author Jankee Patel from Qualpay 
 *
 * @param form_id
 * @returns {boolean}
 */
function gformQualpayHasError(form_id) {

    return jQuery('#gform_confirmation_wrapper_' + form_id).hasClass('gform_validation_error') || jQuery('#gform_ajax_frame_' + form_id).contents().find('#gform_wrapper_' + form_id).hasClass('gform_validation_error');

}
