var qpEmbeddedForm = function () { "use strict"; var iframeSrc = "", host = "", pgSettings = {}, frames = {}; var validFieldNames = ["exp_date", "cvv2", "card_number"]; var frameType = "form"; function addListenEvent(events, listenFn, target) { if (!target) { target = window } if (!Array.isArray(events)) { events = [events] } if (target.addEventListener) { target.addEventListener(events[0], listenFn, false) } else { target.attachEvent(events[1] || events[0], listenFn) } } function qpListener(data) { if (data.ready) { return } if (data.onBlur) { return } if (data.code !== undefined) { if (data.code === 0) { console.log("Passing to success"); if (qpEmbeddedForm.successFunction !== undefined && typeof qpEmbeddedForm.successFunction === "function") { qpEmbeddedForm.successFunction(data) } } else { console.error("Passing to failure"); if (qpEmbeddedForm.failureFunction !== undefined && typeof qpEmbeddedForm.failureFunction === "function") { qpEmbeddedForm.failureFunction(data) } } } else { console.error("Passing to failure", data); if (qpEmbeddedForm.failureFunction !== undefined && typeof qpEmbeddedForm.failureFunction === "function") { qpEmbeddedForm.failureFunction({ code: 99, msg: "Internal Error" }) } } } var onformSubmit = function (event) { event = event ? event : window.event; event.preventDefault(event); submitForm(); return false }; var submitForm = function (event) { if (qpEmbeddedForm.preSubmitFunction) { var result = qpEmbeddedForm.preSubmitFunction(event); if (result === false) return } var iframeId = "qp-embedded-frame"; if (frameType === "fields") { iframeId = "qp-embedded-frame-card-number" } if (document.getElementById(iframeId) !== null) { var iframe = document.getElementById(iframeId).contentWindow; pgSettings.submit = true; iframe.postMessage(JSON.stringify(pgSettings), iframeSrc) } }; var validateInput = function (settings) { var isValid = true; if (!settings) { console.error("Configuration parameters are required when loading the embedded frame"); isValid = false } if (!settings.formId || !document.getElementById(settings.formId)) { console.error("formId is required"); isValid = false } if (!settings.onSuccess || typeof settings.onSuccess !== "function") { console.error("onSuccess function is required"); isValid = false } if (!settings.fields && document.getElementById("qp-embedded-container") === null) { console.error("A DOM element with ID qp-embedded-container is required"); isValid = false } if (settings.preSubmit && typeof settings.preSubmit !== "function") { console.error("settings.preSubmit should be a javascript function.") } if (settings.fields) { if (!settings.fields.card_number || !settings.fields.exp_date) { console.error("card_number and exp_date fields should be defined in fields object."); isValid = false } for (var key in settings.fields) { if (validFieldNames.indexOf(key) < 0) { console.error("Invalid field name " + key); isValid = false; continue } if (!settings.fields[key].id) { console.error("fields.id is required for " + key); isValid = false } else { if (document.getElementById(settings.fields[key].id) === null) { console.error("HTML container element not found for " + key); isValid = false } } if (typeof settings.fields[key].onblur !== "function") { console.error("fields.onblur[" + key + "] should be a javascript function."); isValid = false } if (typeof settings.fields[key].attributes !== "object") { console.error("fields.attributes[" + key + "] should be a JSON object."); isValid = false } } } return isValid }; return { loadFrame: function (mid, settings) { if (!mid || isNaN(mid)) { console.error("Invalid merchant ID"); return } if (!validateInput(settings)) { return } frameType = settings.fields ? "fields" : "form"; var clientForm = document.getElementById(settings.formId); var getEventData = function (event) { if (!event) { return {} } if (event.origin !== host && !event.origin.match(/local/)) { return {} } var data = event.data ? typeof event.data === "string" ? JSON.parse(event.data) : event.data : {}; return data }; var onBlurField = function (data) { if (!data.onBlur) { return } var field = data.fieldName; if (frames[field] !== undefined && frames[field].onBlur !== undefined && typeof frames[field].onBlur === "function") { frames[field].onBlur(data) } }; var readyCheck = function (data) { if (data.ready) { if (document.getElementById("qp-embedded-frame") !== null) { var iframe = document.getElementById("qp-embedded-frame").contentWindow; var embeddedData = { font: settings.font, style: settings.style, paymentRequestConfig: settings.paymentRequestConfig, ready: true }; iframe.postMessage(JSON.stringify(embeddedData), iframeSrc) } else if (data.key && frames[data.key]) { document.getElementById(frames[data.key].id).contentWindow.postMessage(JSON.stringify({ font: settings.font, style: settings.style, paymentRequestConfig: settings.paymentRequestConfig, ready: true, settings: frames[data.key].settings }), frames[data.key].source); document.getElementById(frames[data.key].id).style.display = "block" } return true } return false }; var processEvent = function (event) { if (event && event.origin !== host) { return } var data = getEventData(event); if (data) { if (data.ready) { readyCheck(data) } else if (data.onBlur) { onBlurField(data) } else { qpListener(data) } } }; addListenEvent("submit", onformSubmit, clientForm); addListenEvent(["message", "onmessage"], processEvent); qpEmbeddedForm.successFunction = settings.onSuccess; if (settings.onError !== undefined && typeof settings.onError === "function") { qpEmbeddedForm.failureFunction = settings.onError } if (settings.preSubmit !== undefined && typeof settings.preSubmit === "function") { qpEmbeddedForm.preSubmitFunction = settings.preSubmit } var mode = settings.mode ? settings.mode : "test"; var transient_key = settings.transientKey ? settings.transientKey : ""; pgSettings.tokenize = settings.tokenize ? settings.tokenize : false; host = ""; switch (mode) { case "prod": case "live": host = "https://app.qualpay.com"; break; case "dev": host = "https://app-dev.qualpay.com"; break; case "qa": host = "https://app-qa.qualpay.com"; break; case "local": host = "http://localhost:9001"; break; default: host = "https://app-test.qualpay.com"; break }if (frameType === "fields" && settings.fields) { var frameSrc = host + "/embedded/" + mid; for (var fName in settings.fields) { var src = frameSrc + "/embed-fields/" + transient_key + "/" + fName; var element = document.getElementById(settings.fields[fName].id); frames[fName] = {}; frames[fName].id = "qp-embedded-frame-" + fName.replace("_", "-"); frames[fName].source = src; frames[fName].onBlur = settings.fields[fName].onblur && typeof settings.fields[fName].onblur === "function" ? settings.fields[fName].onblur : ""; if (settings.fields[fName].attributes && typeof settings.fields[fName].attributes === "object") { frames[fName].settings = { settings: true, key: fName, required: settings.fields[fName].attributes.required === true ? true : false, placeholder: settings.fields[fName].attributes.placeholder, id: settings.fields[fName].attributes.id, arialabelledby: settings.fields[fName].attributes.arialabelledby, ariadescribedby: settings.fields[fName].attributes.ariadescribedby } } element.innerHTML = '<iframe frameBorder="0" style="width:100%;height:100%;" id="' + frames[fName].id + '" src="' + src + '" scrolling="no" allowpaymentrequest></iframe>'; if (fName === "card_number") { iframeSrc = src } document.getElementById(frames[fName].id).style.display = "none" } } else { var container = document.getElementById("qp-embedded-container"); iframeSrc = host + "/embedded/" + mid; if (transient_key) { iframeSrc = iframeSrc + "/embed/" + transient_key } container.innerHTML = '<iframe frameBorder="0" style="position:absolute;top:0;left:0;width:100%;height:100%;" id="qp-embedded-frame" src="' + iframeSrc + '" allowpaymentrequest></iframe>' } }, unloadFrame: function () { if (frameType === "fields") { for (var key in frames) { var fieldFrame = document.getElementById(frames[key].id); if (fieldFrame !== null) { fieldFrame.parentNode.removeChild(fieldFrame) } } } else { var formFrame = document.getElementById("qp-embedded-frame"); if (formFrame !== null) { formFrame.parentNode.removeChild(formFrame) } } } } }();