from .base import Base


class StarterTemplate(Base):
    """
    StarterTemplate serves as a customizable template for creating your own child class.
    """

    def __init__(self, api, swift_id, options):

        super().__init__(api, swift_id, options)

    async def run(self):

        print('Dev strategy running..')
        await self.api.request_orderbook_history(self.swift_id, last_n_seconds=100)

        print(
            await self.log_info()
        )

    async def on_deal_done(self, deal):
        print(f'New deal: {deal}')

    async def log_info(self):
        """
        Generates and returns a log message summarizing the strategy's activity.

        :return: A log message summarizing the strategy's activity.
        :rtype: str
        """
        return f"orderbook_history: {self.api.orderbook_history}"
